package com.artfess.examine.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 学习计划表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
@ApiModel(value="ExamStudyPlan对象", description="学习计划表")
public class ExamStudyPlan extends BaseModel<ExamStudyPlan> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "试卷id")
    @TableField("paper_id_")
    private String paperId;

    @ApiModelProperty(value = "计划考试开始时间")
    @TableField("plan_start_time_")
    private LocalDateTime planStartTime;

    @ApiModelProperty(value = "计划考试结束时间")
    @TableField("plan_end_time_")
    private LocalDateTime planEndTime;

    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "排序（按照题型排序）")
    @TableField("sn_")
    private Integer sn;

    @ApiModelProperty(value = "删除标识【字典】（0：未删除，1：已删除）")
    @TableField("is_dele_")
    private String isDele;

    @ApiModelProperty(value = "创建人")
    @TableField("create_by_")
    private String createBy;

    @ApiModelProperty(value = "创建人_组织_ID")
    @TableField("create_org_id_")
    private String createOrgId;

    @ApiModelProperty(value = "创建时间")
    @TableField("create_time_")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "修改人员")
    @TableField("update_by_")
    private String updateBy;

    @ApiModelProperty(value = "修改时间")
    @TableField("update_time_")
    private LocalDateTime updateTime;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPaperId() {
        return paperId;
    }

    public void setPaperId(String paperId) {
        this.paperId = paperId;
    }

    public LocalDateTime getPlanStartTime() {
        return planStartTime;
    }

    public void setPlanStartTime(LocalDateTime planStartTime) {
        this.planStartTime = planStartTime;
    }

    public LocalDateTime getPlanEndTime() {
        return planEndTime;
    }

    public void setPlanEndTime(LocalDateTime planEndTime) {
        this.planEndTime = planEndTime;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }

    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }

    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public String getCreateOrgId() {
        return createOrgId;
    }

    public void setCreateOrgId(String createOrgId) {
        this.createOrgId = createOrgId;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public String getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }

    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "ExamStudyPlan{" +
            "id=" + id +
            ", paperId=" + paperId +
            ", planStartTime=" + planStartTime +
            ", planEndTime=" + planEndTime +
            ", memo=" + memo +
            ", sn=" + sn +
            ", isDele=" + isDele +
            ", createBy=" + createBy +
            ", createOrgId=" + createOrgId +
            ", createTime=" + createTime +
            ", updateBy=" + updateBy +
            ", updateTime=" + updateTime +
        "}";
    }
}
