package com.artfess.examine.model;

import com.artfess.base.entity.BaseModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.FieldRepeat;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;

/**
 * 考场设备管理
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
@Data
@FieldRepeat(fields = {"code","name"},message = "设备名称或代码不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
@ApiModel(value="ExamCameraInfo对象", description="考场设备管理")
public class ExamCameraInfo extends BaseModel<ExamCameraInfo> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请输入设备编号",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "设备编号")
    @TableField("code_")
    private String code;

    @NotBlank(message = "请输入设备名称",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "设备名称")
    @TableField("name_")
    private String name;

    @NotBlank(message = "请选择所属考场",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "所属考场")
    @TableField("room_id_")
    private String roomId;

    @ApiModelProperty(value = "IP地址")
    @TableField("ip_")
    private String ip;

    @ApiModelProperty(value = "端口")
    @TableField("port_")
    private String port;

    @ApiModelProperty(value = "通道号")
    @TableField("aisle_")
    private String aisle;

    @ApiModelProperty(value = "访问地址")
    @TableField("url_")
    private String url;

    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "排序（按照类型排序）")
    @TableField("sn_")
    private Integer sn;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @NotBlank(message = "请选择设备类型",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "设备类型")
    @TableField("type_")
    private String type;

}
