package com.artfess.examine.dao;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.data.vo.UserExamVo;
import com.artfess.examine.model.ExamUserEvaluationDetail;
import com.artfess.examine.vo.PositionVo;
import com.artfess.examine.vo.UserInfoVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 年度考核成绩表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-12-07
 */
public interface ExamUserEvaluationDetailDao extends BaseMapper<ExamUserEvaluationDetail> {

    List<UserInfoVo> getUserList(@Param("positionId") String positionId);

    List<UserInfoVo> getYearUserList(@Param("orgId") String orgId, @Param("year") String year);

    List<ExamUserEvaluationDetail> findByYearParams(@Param("orgId") String orgId, @Param("year") String year);

    List<PositionVo> getPositionList();

    IPage<UserExamVo> userStudyAnalyse(IPage<ExamUserEvaluationDetail> convert2IPage, @Param(Constants.WRAPPER) Wrapper<ExamUserEvaluationDetail> convert2Wrapper);

    String getSubjectNames(@Param("positionId") String positionId, @Param("year") String year, @Param("userId") String userId);

    IPage<ExamUserEvaluationDetail> findByPage(IPage<ExamUserEvaluationDetail> convert2IPage, @Param(Constants.WRAPPER) Wrapper<ExamUserEvaluationDetail> convert2Wrapper);
}
