package com.artfess.data.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.enums.ScoreLevelEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.StringUtil;
import com.artfess.data.dao.BizSubExamDataDao;
import com.artfess.data.manager.BizSubExamDataManager;
import com.artfess.data.model.BizSubExamData;
import com.artfess.examine.dao.ExamOrgEvaluationDao;
import com.artfess.examine.dao.ExamUserEvaluationDetailDao;
import com.artfess.examine.manager.ExamSubjectInfoManager;
import com.artfess.examine.manager.ExamUserEvaluationManager;
import com.artfess.examine.model.ExamSubjectInfo;
import com.artfess.examine.model.ExamUserEvaluationDetail;
import com.artfess.examine.vo.PositionVo;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.api.client.util.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 课目考核数据 服务实现类
 *
 * @author min.wu
 * @company 阿特菲斯信息技术有限公司
 * @since 2024-09-02
 */
@Service
public class BizSubExamDataManagerImpl extends BaseManagerImpl<BizSubExamDataDao, BizSubExamData> implements BizSubExamDataManager {

    @Resource
    private ExamOrgEvaluationDao orgEvaluationDao;

    @Resource
    private ExamUserEvaluationDetailDao userEvaluationDetailDao;

    @Resource
    private ExamUserEvaluationManager userEvaluationManager;

    @Autowired
    private ExamSubjectInfoManager subjectInfoManager;

    @Override
    public void saveData(List<BizSubExamData> list) {
        Assert.notEmpty(list, "导入的课目考核数据为空");
        String year = String.valueOf(LocalDateTime.now().getYear());
        LambdaQueryWrapper<ExamSubjectInfo> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(ExamSubjectInfo::getIsDele, DelStatusEnum.N.getType());
        List<ExamSubjectInfo> subjectInfos = subjectInfoManager.list(lambdaQueryWrapper);
        Map<String, ExamSubjectInfo> subjectInfoMap = subjectInfos.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        list.forEach(subExamData -> {
            if (null != subjectInfoMap.get(subExamData.getSubjectName())) {
                subExamData.setSubjectId(subjectInfoMap.get(subExamData.getSubjectName()).getId());
            }
            if (!StringUtil.isEmpty(subExamData.getRateLevel())) {
                Integer desc = ScoreLevelEnum.getType(subExamData.getRateLevel());
                subExamData.setRateLevel(desc + "");
            }

            subExamData.setYear(year);
        });

//        List<OrgVo> orgVos = orgEvaluationDao.orgList();
//        Map<String, OrgVo> orgMap = orgVos.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        List<PositionVo> positionVoList = userEvaluationDetailDao.getPositionList();
        Map<String, PositionVo> positionMap = positionVoList.stream().collect(Collectors.toMap(item -> item.getPositionName(), item -> item));

        Map<String, List<BizSubExamData>> map = list.stream().collect(Collectors.groupingBy(BizSubExamData::getPost));
        map.forEach((post, data) -> {
            if (null == positionMap.get(post)) {
                return;
            }
            List<ExamUserEvaluationDetail> detail = Lists.newArrayList();
            data.forEach(examData -> {

                ExamUserEvaluationDetail evaluationDetail = new ExamUserEvaluationDetail();
                evaluationDetail.setUserName(examData.getUserName());
                evaluationDetail.setUserName(examData.getUserName());
                evaluationDetail.setPositionId(positionMap.get(post).getPositionId());
                if (null != examData.getScore()) {
                    evaluationDetail.setScore(examData.getScore().toString());
                } else {
                    evaluationDetail.setScore("0");
                }
                evaluationDetail.setLevelDesc(examData.getRateLevel());
                evaluationDetail.setSubjectId(examData.getSubjectId());
                detail.add(evaluationDetail);
            });
            userEvaluationManager.importExcel(detail, positionMap.get(post).getPositionId());
        });
        this.saveBatch(list);

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean createInfo(BizSubExamData examData) {

        boolean save = this.save(examData);
        if (save) {
            List<ExamUserEvaluationDetail> detail = Lists.newArrayList();
            ExamUserEvaluationDetail evaluationDetail = new ExamUserEvaluationDetail();
            evaluationDetail.setUserName(examData.getUserName());
            evaluationDetail.setUserName(examData.getUserName());
            evaluationDetail.setPositionId(examData.getPostId());
            if (null != examData.getScore()) {
                evaluationDetail.setScore(examData.getScore().toString());
            } else {
                evaluationDetail.setScore("0");
            }
            evaluationDetail.setLevelDesc(examData.getRateLevel());
            evaluationDetail.setSubjectId(examData.getSubjectId());
            detail.add(evaluationDetail);
            userEvaluationManager.importExcel(detail, examData.getPostId());
        }
        return save;
    }


}
