package com.artfess.data.dto;

import com.artfess.data.model.BizSubjectScoreCount;
import com.artfess.data.model.BizUserAchieveDetail;
import com.artfess.data.model.BizUserGrade;
import com.artfess.data.model.BizUserThroughDetail;
import com.artfess.examine.model.ExamUserEvaluation;
import com.artfess.examine.model.ExamUserEvaluationDetail;
import com.artfess.examine.model.ExamUserEvaluationDetailTy;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

@lombok.Data
@ApiModel(value="PersonalProfileDto对象", description="个人档案详细信息每年")
public class PersonalProfileDto {

    @ApiModelProperty(value = "年份")
    private Integer year;

    @ApiModelProperty(value = "XXX资质及成果表（按年明细记录表）")
    @TableField(exist = false)
    private List<BizUserAchieveDetail> bizUserAchieveDetailList;

    @ApiModelProperty(value = "xxx成绩与奖惩表（按年成绩明细记录表）")
    @TableField(exist = false)
    private List<BizUserGrade> bizUserGradeList;

    @ApiModelProperty(value = "xxx经历表（按年明细记录表）")
    @TableField(exist = false)
    private List<BizUserThroughDetail> bizUserThroughDetailList;

    @ApiModelProperty(value = "年度综合评定表")
    @TableField(exist = false)
    private ExamUserEvaluation examUserEvaluation;

//    @ApiModelProperty(value = "年度考核考生---各科目成绩表")
//    @TableField(exist = false)
//    private List<ExamUserEvaluationDetail> examUserEvaluationDetailList;

    @ApiModelProperty(value = "年度考核考生---专 业 共 同")
    @TableField(exist = false)
    private List<ExamUserEvaluationDetailTy> professionalCommonDetail;

    @ApiModelProperty(value = "年度考核考生---专 业 X X")
    @TableField(exist = false)
    private List<ExamUserEvaluationDetailTy> professionalXXDetail;

    @ApiModelProperty(value = "年度考核考生---X X 共 同")
    @TableField(exist = false)
    private List<ExamUserEvaluationDetailTy> XXCommonDetail;

    @ApiModelProperty(value = "年度考核考生---X X 体 育")
    @TableField(exist = false)
    private List<ExamUserEvaluationDetailTy> XXSportsDetail;

    @ApiModelProperty(value = "年度考核考生---成绩统计")
    private List<BizSubjectScoreCount> subjectScoreCounts;

}
