/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.uc.dao.OrgJobDao;
import com.artfess.uc.dao.OrgPostDao;
import com.artfess.uc.exception.RequiredException;
import com.artfess.uc.manager.OrgJobManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.OrgJob;
import com.artfess.uc.model.OrgPost;
import com.artfess.uc.model.User;
import com.artfess.uc.params.job.JobVo;
import com.artfess.uc.params.user.UserVo;
import com.artfess.uc.util.OrgUtil;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgJobManagerImpl
extends BaseManagerImpl<OrgJobDao, OrgJob>
implements OrgJobManager {
    @Autowired
    OrgPostDao orgPostDao;
    @Autowired
    UserManager userService;

    @Override
    public OrgJob getByCode(String code) {
        return ((OrgJobDao)this.baseMapper).getByCode(code);
    }

    @Override
    public List<OrgJob> getByName(String name) {
        return ((OrgJobDao)this.baseMapper).getByName(name);
    }

    @Transactional
    public void removeByIds(String ... ids) {
        for (String id : ids) {
            List<OrgPost> relList = this.orgPostDao.getByReldefId(id);
            OrgJob reldef = (OrgJob)this.getById((Serializable)((Object)id));
            if (!BeanUtils.isNotEmpty(relList)) continue;
            ThreadMsgUtil.addMsg((String)(reldef.getName() + "\u5df2\u4e0e\u5c97\u4f4d\u5173\u8054\uff0c\u4e0d\u80fd\u5220\u9664\uff01"));
        }
        if (StringUtil.isEmpty((String)ThreadMsgUtil.getMessage((boolean)false))) {
            super.removeByIds(ids);
        }
    }

    @Override
    public List<OrgJob> getListByUserId(String userId) {
        ArrayList<OrgJob> OrgJobs = new ArrayList<OrgJob>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        List<OrgPost> orgPosts = this.orgPostDao.getRelListByParam(map);
        if (BeanUtils.isEmpty(orgPosts)) {
            return OrgJobs;
        }
        for (OrgPost orgPost : orgPosts) {
            OrgJob OrgJob2 = (OrgJob)this.get((Serializable)((Object)orgPost.getRelDefId()));
            OrgJobs.add(OrgJob2);
        }
        OrgUtil.removeDuplicate(OrgJobs, "code");
        return OrgJobs;
    }

    @Override
    public List<OrgJob> getListByAccount(String account) {
        ArrayList<OrgJob> OrgJobs = new ArrayList<OrgJob>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("account", account);
        List<OrgPost> orgPosts = this.orgPostDao.getRelListByParam(map);
        if (BeanUtils.isEmpty(orgPosts)) {
            return OrgJobs;
        }
        for (OrgPost orgPost : orgPosts) {
            OrgJob OrgJob2 = (OrgJob)this.get((Serializable)((Object)orgPost.getRelDefId()));
            OrgJobs.add(OrgJob2);
        }
        return OrgJobs;
    }

    @Override
    @Transactional
    public CommonResult<String> addJob(JobVo jobVo) throws Exception {
        if (StringUtil.isEmpty((String)jobVo.getName())) {
            throw new RequiredException("\u6dfb\u52a0\u4eba\u5458\u7c7b\u522b\u5931\u8d25\uff0c\u4eba\u5458\u7c7b\u522b\u540d\u79f0\u3010name\u3011\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)jobVo.getCode())) {
            throw new RequiredException("\u6dfb\u52a0\u4eba\u5458\u7c7b\u522b\u5931\u8d25\uff0c\u4eba\u5458\u7c7b\u522b\u7f16\u7801\u3010code\u3011\u5fc5\u586b\uff01");
        }
        if (jobVo.getCode().contains(",")) {
            throw new RuntimeException("\u4eba\u5458\u7c7b\u522b\u7f16\u7801\u4e0d\u80fd\u5305\u542b\u82f1\u6587\u9017\u53f7\u2018,\u2019");
        }
        if (((OrgJobDao)this.baseMapper).getCountByCode(jobVo.getCode()) > 0) {
            return new CommonResult(false, "\u6dfb\u52a0\u4eba\u5458\u7c7b\u522b\u5931\u8d25\uff0c\u4eba\u5458\u7c7b\u522b\u7f16\u7801\u3010" + jobVo.getCode() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff01", (Object)"");
        }
        OrgJob job = new OrgJob();
        job.setName(jobVo.getName());
        job.setCode(jobVo.getCode());
        job.setDescription(jobVo.getDescription());
        job.setId(UniqueIdUtil.getSuid());
        job.setPostLevel(jobVo.getPostLevel());
        this.create((Model)job);
        return new CommonResult(true, "\u6dfb\u52a0\u4eba\u5458\u7c7b\u522b\u6210\u529f\uff01", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> deleteJob(String codes) throws Exception {
        String msg;
        String[] codeArray = codes.split(",");
        StringBuilder str = new StringBuilder();
        StringBuilder posStr = new StringBuilder();
        boolean isTrue = true;
        for (String code : codeArray) {
            OrgJob job = this.getByCode(code);
            if (BeanUtils.isNotEmpty((Object)job)) {
                List<OrgPost> orgPosts = this.orgPostDao.getByReldefId(job.getId());
                if (BeanUtils.isEmpty(orgPosts)) {
                    this.remove((Serializable)((Object)job.getId()));
                    continue;
                }
                posStr.append(code);
                posStr.append("\uff0c");
                isTrue = false;
                continue;
            }
            isTrue = false;
            str.append(code);
            str.append("\uff0c");
        }
        String string = msg = isTrue ? "\u5220\u9664\u4eba\u5458\u7c7b\u522b\u6210\u529f\uff01" : "\u90e8\u5206\u5220\u9664\u5931\u8d25\uff0c";
        if (!isTrue) {
            if (str.length() > 0) {
                msg = msg + "\u4eba\u5458\u7c7b\u522b\u7f16\u7801\u3010" + str.toString().substring(0, str.length() - 1) + "\u3011\u4e0d\u5b58\u5728\uff01";
            }
            if (posStr.length() > 0) {
                msg = msg + "\u4eba\u5458\u7c7b\u522b\u7f16\u7801\u3010" + posStr.toString().substring(0, posStr.length() - 1) + "\u3011\u4e0b\u5b58\u5728\u5c97\u4f4d\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01";
            }
        }
        return new CommonResult(isTrue, msg, (Object)str.toString());
    }

    @Override
    @Transactional
    public CommonResult<String> deleteJobByIds(String ids) {
        String msg;
        String[] idArray = ids.split(",");
        StringBuilder str = new StringBuilder();
        StringBuilder posStr = new StringBuilder();
        boolean isTrue = true;
        for (String id : idArray) {
            OrgJob job = (OrgJob)this.get((Serializable)((Object)id));
            if (BeanUtils.isNotEmpty((Object)job)) {
                List<OrgPost> orgPosts = this.orgPostDao.getByReldefId(job.getId());
                if (BeanUtils.isEmpty(orgPosts)) {
                    this.remove((Serializable)((Object)job.getId()));
                    continue;
                }
                posStr.append(job.getName());
                posStr.append("\uff0c");
                isTrue = false;
                continue;
            }
            isTrue = false;
            str.append(job.getName());
            str.append("\uff0c");
        }
        String string = msg = isTrue ? "\u5220\u9664\u4eba\u5458\u7c7b\u522b\u6210\u529f\uff01" : "\u90e8\u5206\u5220\u9664\u5931\u8d25\uff0c";
        if (!isTrue) {
            if (str.length() > 0) {
                msg = msg + "\u4eba\u5458\u7c7b\u522b\u7f16\u7801\u3010" + str.toString().substring(0, str.length() - 1) + "\u3011\u4e0d\u5b58\u5728\uff01";
            }
            if (posStr.length() > 0) {
                msg = msg + "\u4eba\u5458\u7c7b\u522b\u7f16\u7801\u3010" + posStr.toString().substring(0, posStr.length() - 1) + "\u3011\u4e0b\u5b58\u5728\u5c97\u4f4d\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01";
            }
        }
        return new CommonResult(isTrue, msg, (Object)str.toString());
    }

    @Override
    @Transactional
    public CommonResult<String> updateJob(JobVo jobVo) throws Exception {
        if (StringUtil.isEmpty((String)jobVo.getCode())) {
            throw new RequiredException("\u66f4\u65b0\u4eba\u5458\u7c7b\u522b\u5931\u8d25\uff0c\u4eba\u5458\u7c7b\u522b\u7f16\u7801\u3010code\u3011\u5fc5\u586b\uff01");
        }
        OrgJob job = (OrgJob)((OrgJobDao)this.baseMapper).selectById((Serializable)((Object)jobVo.getId()));
        if (BeanUtils.isEmpty((Object)job)) {
            return new CommonResult(false, "\u66f4\u65b0\u4eba\u5458\u7c7b\u522b\u5931\u8d25\uff0c\u4eba\u5458\u7c7b\u522b\u7f16\u7801\u3010" + jobVo.getCode() + "\u3011\u4e0d\u5b58\u5728\uff01", (Object)"");
        }
        if (StringUtil.isNotEmpty((String)jobVo.getName())) {
            job.setName(jobVo.getName());
        }
        if (jobVo.getDescription() != null) {
            job.setDescription(jobVo.getDescription());
        }
        if (jobVo.getPostLevel() != null) {
            job.setPostLevel(jobVo.getPostLevel());
        }
        this.update((Model)job);
        return new CommonResult(true, "\u66f4\u65b0\u4eba\u5458\u7c7b\u522b\u6210\u529f\uff01", (Object)"");
    }

    @Override
    public List<UserVo> getUsersByJob(String codes) throws Exception {
        String[] codeArray;
        ArrayList<User> list = new ArrayList<User>();
        for (String code : codeArray = codes.split(",")) {
            OrgJob job = this.getByCode(code);
            String jobId = "";
            jobId = BeanUtils.isNotEmpty((Object)job) ? job.getId() : code;
            List<User> users = this.userService.getListByJobId(jobId);
            if (!BeanUtils.isNotEmpty(users)) continue;
            list.addAll(users);
        }
        OrgUtil.removeDuplicate(list);
        return OrgUtil.convertToUserVoList(list);
    }

    @Override
    public List<OrgJob> getJobByTime(String btime, String etime) throws Exception {
        QueryFilter queryFilter = OrgUtil.getDataByTimeFilter(btime, etime);
        return this.queryNoPage(queryFilter);
    }

    @Override
    public CommonResult<Boolean> isCodeExist(String code) throws Exception {
        boolean isExist;
        OrgJob job = ((OrgJobDao)this.baseMapper).getByCode(code);
        return new CommonResult(isExist, (isExist = BeanUtils.isNotEmpty((Object)job)) ? "\u8be5\u4eba\u5458\u7c7b\u522b\u7f16\u7801\u5df2\u5b58\u5728\uff01" : "", (Object)isExist);
    }

    @Override
    @Transactional
    public Integer removePhysical() {
        return ((OrgJobDao)this.baseMapper).removePhysical();
    }

    @Override
    public boolean insertBatch(List<OrgJob> list) {
        return this.saveBatch(list);
    }

    @Override
    @Transactional
    public CommonResult<String> addJobFromExterUni(OrgJob jobVo) throws Exception {
        if (StringUtil.isEmpty((String)jobVo.getName())) {
            throw new RequiredException("\u6dfb\u52a0\u4eba\u5458\u7c7b\u522b\u5931\u8d25\uff0c\u4eba\u5458\u7c7b\u522b\u540d\u79f0\u3010name\u3011\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)jobVo.getCode())) {
            throw new RequiredException("\u6dfb\u52a0\u4eba\u5458\u7c7b\u522b\u5931\u8d25\uff0c\u4eba\u5458\u7c7b\u522b\u7f16\u7801\u3010code\u3011\u5fc5\u586b\uff01");
        }
        if (jobVo.getCode().contains(",")) {
            throw new RuntimeException("\u4eba\u5458\u7c7b\u522b\u7f16\u7801\u4e0d\u80fd\u5305\u542b\u82f1\u6587\u9017\u53f7\u2018,\u2019");
        }
        if (((OrgJobDao)this.baseMapper).getCountByCode(jobVo.getCode()) > 0) {
            return new CommonResult(false, "\u6dfb\u52a0\u4eba\u5458\u7c7b\u522b\u5931\u8d25\uff0c\u4eba\u5458\u7c7b\u522b\u7f16\u7801\u3010" + jobVo.getCode() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff01", (Object)"");
        }
        OrgJob job = new OrgJob();
        job.setName(jobVo.getName());
        job.setCode(jobVo.getCode());
        job.setDescription(jobVo.getDescription());
        if (BeanUtils.isEmpty((Object)jobVo.getId())) {
            job.setId(UniqueIdUtil.getSuid());
        } else {
            if (BeanUtils.isNotEmpty((Object)this.get((Serializable)((Object)jobVo.getId())))) {
                throw new RuntimeException("\u6dfb\u52a0\u4eba\u5458\u7c7b\u522b\u5931\u8d25\uff0c\u4eba\u5458\u7c7b\u522bID\u3010" + jobVo.getId() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff01");
            }
            job.setId(jobVo.getId());
        }
        job.setPostLevel(jobVo.getPostLevel());
        this.create((Model)job);
        return new CommonResult(true, "\u6dfb\u52a0\u4eba\u5458\u7c7b\u522b\u6210\u529f\uff01", (Object)"");
    }
}

