package com.artfess.sysConfig.persistence.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.sysConfig.persistence.model.SysIdentity;

import java.io.IOException;
import java.util.List;
import java.util.Map;

public interface SysIdentityManager extends BaseManager<SysIdentity>{
	/**
	 * 判读单据号规则别名是否已经存在
	 * @param id  id为null 表明是新增的单据号规则，否则为更新单据号规则
	 * @param alias
	 * @return
	 */
	boolean isAliasExisted(Map<String,Object> params);

	/**
	 * 根据别名获取当前单据号规则
	 * @param alias
	 * @return
	 */
	public String getCurIdByAlias(String alias);

	/**
	 * 根据别名获取下一个单据号规则
	 * @param alias
	 * @return
	 */
	public String nextId(String alias);

	/**
	 * 根据别名预览前十条单据号规则
	 * @param alias
	 * @return
	 */
	public List<SysIdentity> getPreviewIden(String alias);

    String export(String[] idList) throws IOException;

	void importFile(String unZipFilePath) throws Exception;
}
