package com.artfess.sysConfig.persistence.dao;

import com.artfess.sysConfig.persistence.model.SysIdentity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;

import java.util.Map;

public interface SysIdentityDao extends BaseMapper<SysIdentity> {


	/**
	 * 判读单据号规则别名是否已经存在
	 * param id  id为null 表明是新增的单据号规则，否则为更新单据号规则
	 * @param params
	 * @return
	 */
	Integer isAliasExisted(Map<String,Object> params);

	/**
	 * 根据别名获取单据号规则数据（数据库锁定了对应的行数据）
	 * @param alias
	 * @return
	 */
	SysIdentity getByAlias(String alias);


	/**
	 * 根据流程别名 。
	 * @param identity
	 * void
	 */
	int updByAlias(SysIdentity identity);

	/**
	 * 根据流程别名 。
	 * @param identity
	 * void
	 */
	int updByAliasWithDay(SysIdentity identity);
}
