package com.artfess.file.persistence.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.file.model.FileZone;

import java.util.List;

/**
 * 文件分片记录 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2021-12-29
 */
public interface FileZoneManager extends BaseManager<FileZone> {

    /**
    * 根据文件的MD5值查询其切片信息
    * @param md5Value   文件的MD5
    * @Return: java.util.List<com.artfess.file.model.FileZone>
    * @Author: chens
    * @Date: 2021/12/30 14:22
    */
    List<FileZone> queryByMd5Value(String md5Value, Long fileSize);

    /**
     * 根据文件的MD5值查询其切片个数
     * @param md5Value   文件的MD5
     * @param fileSize   文件的大小
     * @Return: int
     * @Author: chens
     * @Date: 2021/12/30 14:22
     */
    Integer countByMd5AndSize(String md5Value,Long fileSize);

    /**
    * 根据文件的MD5值删除切片信息
    * @param md5Value   文件的MD5
    * @param fileSize   文件的大小
    * @Return: boolean
    * @Author: chens
    * @Date: 2021/12/30 14:51
    */
    boolean removeZoneByMd5AndSize(String md5Value,Long fileSize);
}
