
package com.artfess.file.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.file.model.FileConfig;
import com.artfess.file.params.FileStorageConfigDTO;
import com.artfess.file.persistence.manager.FileConfigManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 附件配置信息 前端控制器
 *
 * @company rzx
 * @author wh
 * @since 2021-03-04
 */
@RestController
@RequestMapping("/file/fileConfig/v1/")
@Api(tags="附件配置")
@ApiGroup(group= {ApiGroupConsts.GROUP_SYSTEM})
public class FileConfigController extends BaseController<FileConfigManager, FileConfig> {

    @Resource
    private FileConfigManager fileConfigManager;

    @PostMapping(value="/queryPage", produces={"application/json; charset=utf-8" })
    @ApiOperation("分页查询结果")
    public PageList<FileConfig> queryPage(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<FileConfig> queryFilter) {
        return fileConfigManager.queryPage(queryFilter);
    }

    @GetMapping("/getOneById")
    @ApiOperation("根据id查询实体")
    public FileConfig getOneById(@ApiParam(name="id", value="实体id",required = true) @RequestParam String id) {
        return fileConfigManager.getOneById(id);
    }

    @PostMapping(value="insertFileConfig")
    @ApiOperation(value = "新增附件配置", httpMethod = "POST", notes = "新增附件配置")
    public CommonResult<String> insertFileConfig(@ApiParam(name="fileConfig",value="附件配置对象")@RequestBody FileConfig fileConfig) throws Exception {
        fileConfigManager.insertFileConfig(fileConfig);
        return new CommonResult<>("新增成功");
    }


    @PostMapping(value="updateFileConfig")
    @ApiOperation(value = "修改附件配置", httpMethod = "POST", notes = "修改附件配置")
    public CommonResult<String> updateFileConfig(@ApiParam(name="fileConfig",value="附件配置对象")@RequestBody FileConfig fileConfig) throws Exception {
        String id = fileConfigManager.updateFileConfig(fileConfig);
        return new CommonResult<String>("修改成功");
    }


    @DeleteMapping(value="deleteFileConfig")
    @ApiOperation(value = "批量删除附件配置", httpMethod = "DELETE", notes = "批量删除附件配置")
    public CommonResult<String> deleteFileConfig(@ApiParam(name="ids",value="业务主键数组,多个业务主键之间用逗号分隔", required = true)@RequestParam String ids) throws Exception {
        fileConfigManager.deleteFileConfig(ids);
        return new CommonResult<String>(true, "删除成功");
    }


    @GetMapping("getFileConfigByCode/{code}")
    @ApiOperation(value = "通过附件配置编码查询附件配置信息",httpMethod = "GET",notes = "通过附件配置编码查询附件配置信息")
    public FileStorageConfigDTO getFileConfigByCode(@ApiParam(name = "code",value="附件配置CODE")@PathVariable String code) throws Exception{
        FileStorageConfigDTO fileConfig = fileConfigManager.getFileConfigByCode(code);
        return fileConfig;
    }
}
