package com.artfess.bpm.persistence.dao;

import com.artfess.bpm.persistence.model.BpmBusLink;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;


public interface BpmBusLinkDao extends BaseMapper<BpmBusLink> {

	
	BpmBusLink getByBusinesKey(Map<String, Object> params);
	/**
	 * 根据业务主键删除数据。
	 * @param businessKey
	 * @param formIdentity
	 * @param isNumber 
	 * void
	 */
	void delByBusinesKey(Map<String, Object> params);
	
	/**
	 * 根据流程实例获取关联数据(主实体)。
	 * @param instId
	 * @return 
	 * List&lt;BpmBusLink>
	 */
	List<BpmBusLink> getByInstId(@Param("procInstId") String instId);
	
	/**
	 * 根据流程实例获取关联数据(主子实体等)。
	 * @param instId
	 * @return
	 */
	List<BpmBusLink> getAllByInstId(@Param("procInstId") String instId);


	String getMysqlVersion();
	
	/**
	 * 根据流程ID获取关联数据。
	 * @param instId
	 * @return 
	 * List&lt;BpmBusLink>
	 */
	List<BpmBusLink> getByDefId(@Param("defId") String defId);
	
	/**
	 * 批量插入
	 * @param list
	 * @return
	 */
	boolean insertBatch(@Param("list") List<BpmBusLink> list);
	
	/**
	 * 批量更新
	 * @param list
	 * @return
	 */
	boolean updateBatch(@Param("list") List<BpmBusLink> list);
	
	/**
	 * 批量删除
	 * @param list
	 * @return
	 */
	boolean deleteBatch(@Param("list") List<String> list);
	
	/**
	 * 批量删除
	 * @param list
	 * @return
	 */
	boolean delBatchByBusinesKey(@Param("list") List<Map<String, Object>> list);
}
