/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.plugin.task.tasknotify.context;

import com.artfess.base.util.JAXBUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.XmlUtil;
import com.artfess.bpm.api.constant.EventType;
import com.artfess.bpm.api.constant.ExtractType;
import com.artfess.bpm.api.constant.LogicType;
import com.artfess.bpm.api.model.process.nodedef.ext.extmodel.UserAssignRule;
import com.artfess.bpm.api.plugin.core.context.AbstractBpmTaskPluginContext;
import com.artfess.bpm.api.plugin.core.def.BpmPluginDef;
import com.artfess.bpm.api.plugin.core.runtime.RunTimePlugin;
import com.artfess.bpm.plugin.task.tasknotify.def.TaskNotifyPluginDef;
import com.artfess.bpm.plugin.task.tasknotify.def.model.NotifyItem;
import com.artfess.bpm.plugin.task.tasknotify.def.model.NotifyVo;
import com.artfess.bpm.plugin.task.tasknotify.entity.ObjectFactory;
import com.artfess.bpm.plugin.task.tasknotify.entity.OnComplete;
import com.artfess.bpm.plugin.task.tasknotify.entity.OnCreate;
import com.artfess.bpm.plugin.task.tasknotify.entity.TaskNotify;
import com.artfess.bpm.plugin.task.tasknotify.plugin.TaskNotifyPlugin;
import com.artfess.bpm.plugin.task.tasknotify.util.NotifyUtil;
import com.artfess.bpm.plugin.usercalc.cusers.context.CusersPluginContext;
import com.artfess.bpm.plugin.usercalc.cusers.def.CusersPluginDef;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jamesmurty.utils.XMLBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class TaskNotifyPluginContext
extends AbstractBpmTaskPluginContext {
    private static final long serialVersionUID = -6584297241598862949L;

    @Override
    public Class<? extends RunTimePlugin> getPluginClass() {
        return TaskNotifyPlugin.class;
    }

    @Override
    public List<EventType> getEventTypes() {
        ArrayList<EventType> eventTypes = new ArrayList<EventType>();
        eventTypes.add(EventType.TASK_POST_CREATE_EVENT);
        eventTypes.add(EventType.TASK_COMPLETE_EVENT);
        return eventTypes;
    }

    private NotifyVo convert(OnCreate onCreate, Element pluginEl) {
        NotifyVo notifyVo = new NotifyVo();
        notifyVo.setEventType(EventType.TASK_POST_CREATE_EVENT);
        Element onCreateEl = XmlUtil.getChildNodeByName((Element)pluginEl, (String)"onCreate");
        List<NotifyItem> notifyItems = NotifyUtil.parseNotifyItems(onCreateEl);
        notifyVo.setNotifyItemList(notifyItems);
        return notifyVo;
    }

    private NotifyVo convert(OnComplete onComplete, Element pluginEl) {
        NotifyVo notifyVo = new NotifyVo();
        notifyVo.setEventType(EventType.TASK_COMPLETE_EVENT);
        Element onCompleteEl = XmlUtil.getChildNodeByName((Element)pluginEl, (String)"onComplete");
        List<NotifyItem> notifyItems = NotifyUtil.parseNotifyItems(onCompleteEl);
        notifyVo.setNotifyItemList(notifyItems);
        return notifyVo;
    }

    @Override
    public String getPluginXml() {
        TaskNotifyPluginDef def = (TaskNotifyPluginDef)this.getBpmPluginDef();
        try {
            XMLBuilder xmlBuilder = XMLBuilder.create((String)"taskNotify").a("xmlns", "http://www.jee-soft.cn/bpm/plugins/task/taskNotify");
            xmlBuilder = xmlBuilder.e("onCreate");
            NotifyVo createVo = def.getNotifyVos().get((Object)EventType.TASK_POST_CREATE_EVENT);
            if (createVo != null) {
                NotifyUtil.handXmlBuilder(createVo, xmlBuilder);
            }
            xmlBuilder = xmlBuilder.up();
            xmlBuilder = xmlBuilder.e("onComplete");
            NotifyVo completeVo = def.getNotifyVos().get((Object)EventType.TASK_COMPLETE_EVENT);
            if (completeVo != null) {
                NotifyUtil.handXmlBuilder(completeVo, xmlBuilder);
            }
            return xmlBuilder.asString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static void main(String[] args) {
        TaskNotifyPluginContext ctx = new TaskNotifyPluginContext();
        TaskNotifyPluginDef def = new TaskNotifyPluginDef();
        ctx.setBpmPluginDef(def);
        Map<EventType, NotifyVo> map = def.getNotifyVos();
        NotifyVo createVo = new NotifyVo();
        NotifyVo completeVo = new NotifyVo();
        createVo.setEventType(EventType.TASK_POST_CREATE_EVENT);
        NotifyItem notifyItem = new NotifyItem();
        ArrayList<NotifyItem> itemList = new ArrayList<NotifyItem>();
        itemList.add(notifyItem);
        ArrayList<UserAssignRule> assignRules = new ArrayList<UserAssignRule>();
        UserAssignRule rule = new UserAssignRule();
        rule.setCondition("aaa>0");
        rule.setGroupNo(1);
        CusersPluginContext cuserctx = new CusersPluginContext();
        CusersPluginDef cdef = new CusersPluginDef();
        cdef.setAccount("zhangyg");
        cdef.setExtract(ExtractType.EXACT_NOEXACT);
        cdef.setSource("spec");
        cdef.setUserName("zhangyg");
        cdef.setLogicCal(LogicType.OR);
        cuserctx.setBpmPluginDef(cdef);
        rule.getCalcPluginContextList().add(cuserctx);
        assignRules.add(rule);
        notifyItem.setMsgTypes("sms,mail");
        notifyItem.setUserAssignRules(assignRules);
        createVo.setNotifyItemList(itemList);
        completeVo.setEventType(EventType.TASK_COMPLETE_EVENT);
        map.put(EventType.TASK_POST_CREATE_EVENT, createVo);
        map.put(EventType.TASK_COMPLETE_EVENT, completeVo);
    }

    @Override
    public String getJson() throws IOException {
        TaskNotifyPluginDef def = (TaskNotifyPluginDef)this.getBpmPluginDef();
        Collection<NotifyVo> assignRules = def.getNotifyVos().values();
        ObjectNode config = JsonUtil.getMapper().createObjectNode();
        NotifyUtil.getJsonConfig(config, assignRules);
        ObjectNode json = (ObjectNode)config.putAll((ObjectNode)JsonUtil.toJsonNode((Object)def));
        return json.toString();
    }

    @Override
    protected BpmPluginDef parseJson(String pluginJson) throws Exception {
        TaskNotifyPluginDef notifyPluginDef = new TaskNotifyPluginDef();
        ObjectNode jsonObject = JsonUtil.getMapper().createObjectNode();
        ArrayNode createJson = (ArrayNode)jsonObject.get(EventType.TASK_POST_CREATE_EVENT.getKey());
        ArrayNode completeJson = (ArrayNode)jsonObject.get(EventType.TASK_COMPLETE_EVENT.getKey());
        NotifyVo createVo = NotifyUtil.getNotifyVo(createJson);
        NotifyVo completeVo = NotifyUtil.getNotifyVo(completeJson);
        notifyPluginDef.addNotifyVo(EventType.TASK_POST_CREATE_EVENT, createVo);
        notifyPluginDef.addNotifyVo(EventType.TASK_COMPLETE_EVENT, completeVo);
        return notifyPluginDef;
    }

    @Override
    protected BpmPluginDef parseElement(Element element) {
        String xml = XmlUtil.getXML((Element)element);
        TaskNotifyPluginDef notifyPluginDef = new TaskNotifyPluginDef();
        try {
            OnComplete onComplete;
            TaskNotify taskNotify = (TaskNotify)JAXBUtil.unmarshall((String)xml, ObjectFactory.class);
            ArrayList<NotifyVo> notifyVoList = new ArrayList<NotifyVo>();
            OnCreate onCreate = taskNotify.getOnCreate();
            if (onCreate != null) {
                NotifyVo notityVoOnCreate = this.convert(onCreate, element);
                notifyVoList.add(notityVoOnCreate);
                notifyPluginDef.getNotifyVos().put(EventType.TASK_POST_CREATE_EVENT, notityVoOnCreate);
            }
            if ((onComplete = taskNotify.getOnComplete()) != null) {
                NotifyVo notifyVoOnComplete = this.convert(onComplete, element);
                notifyVoList.add(notifyVoOnComplete);
                notifyPluginDef.getNotifyVos().put(EventType.TASK_COMPLETE_EVENT, notifyVoOnComplete);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return notifyPluginDef;
    }

    @Override
    public String getTitle() {
        return "\u4efb\u52a1\u901a\u77e5\u64cd\u9001";
    }
}

