package com.artfess.uc.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 组织岗位中间表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-11-08
 */
@ApiModel(value="UcOrgPosition对象", description="组织岗位中间表")
public class UcOrgPosition extends BaseModel<UcOrgPosition> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "组织id")
    @TableField("org_id_")
    private String orgId;

    @ApiModelProperty(value = "岗位id")
    @TableField("pos_id_")
    private String posId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOrgId() {
        return orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public String getPosId() {
        return posId;
    }

    public void setPosId(String posId) {
        this.posId = posId;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "UcOrgPosition{" +
            "id=" + id +
            ", orgId=" + orgId +
            ", posId=" + posId +
        "}";
    }
}
