package com.artfess.sysConfig.persistence.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.QueryFilter;
import com.artfess.sysConfig.persistence.model.SysApp;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;

/**
 *
 * <pre>
 * 描述：portal_sys_app 处理接口
 * 构建组：x7
 * 作者:qiuxd
 * 邮箱:qiuxd@jee-soft.cn
 * 日期:2020-08-20 15:17:19
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
public interface SysAppManager extends BaseManager<SysApp>{

    List<SysApp> queryByAuth(SysApp sysApp) throws Exception;

    List<SysApp> queryByTagIds(String menuId, List<Map<String,String>> maps);

    List<String> getValidMenu(String userId);

    List<SysApp> queryByFilter(QueryFilter<SysApp> queryFilter);

    Map<String,String> exportData(List<String> ids) throws Exception;

    void importData(MultipartFile file);
}
