package com.artfess.portal.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 *
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2020-12-01
 */
@TableName("portal_shorturl_manage")
@ApiModel(value="ShorturlManage对象", description="")
public class ShorturlManage extends AutoFillModel<ShorturlManage> implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "原链接")
    @TableField("url_")
    private String url;

    @ApiModelProperty(value = "原链接描述")
    @TableField("url_desc_")
    private String urlDesc;

    @ApiModelProperty(value = "短链接")
    @TableField("short_url_")
    private String shortUrl;

    @ApiModelProperty(value = "失效时间(单位分钟)，为空则表示长期有效")
    @TableField("lose_time_")
    private LocalDateTime loseTime;

    @ApiModelProperty(value = "是否启用.1:启用，2：禁用。默认启用")
    @TableField("enabled_")
    private String enabled;

    @ApiModelProperty(value = "访客token")
    @TableField(exist=false)
    private String guestToken;

    @ApiModelProperty(value = "租户ID")
    @TableField("tenant_id_")
    private String tenantId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
    public String getShortUrl() {
        return shortUrl;
    }

    public void setShortUrl(String shortUrl) {
        this.shortUrl = shortUrl;
    }

	public String getEnabled() {
        return enabled;
    }

    public void setEnabled(String enabled) {
        this.enabled = enabled;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

	public String getGuestToken() {
		return guestToken;
	}

	public void setGuestToken(String guestToken) {
		this.guestToken = guestToken;
	}

	public String getUrlDesc() {
		return urlDesc;
	}

	public void setUrlDesc(String urlDesc) {
		this.urlDesc = urlDesc;
	}

	public LocalDateTime getLoseTime() {
		return loseTime;
	}

	public void setLoseTime(LocalDateTime loseTime) {
		this.loseTime = loseTime;
	}

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }
}
