package com.artfess.portal.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.portal.params.ActuatorInfo;
import com.artfess.portal.params.TraceInfo;
import com.artfess.portal.persistence.manager.ActuatorSystemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * @author wh
 * @Package com.sysplat.sys.modules.monitor.controller
 * @date 2020/7/7 14:15
 * @Description:
 * ---	JVM
 * 1	jvm.memory.max	JVM最大内存
 * 2	jvm.memory.committed	JVM可用内存
 * 3	jvm.memory.used	JVM已用内存
 * 4	jvm.buffer.memory.used	JVM缓冲区已用内存
 * 5	jvm.buffer.count	当前缓冲区数
 * 6	jvm.threads.daemon	JVM守护线程数
 * 7	jvm.threads.live	JVM当前活跃线程数
 * 8	jvm.threads.peak	JVM峰值线程数
 * 9	jvm.classes.loaded	加载classes数
 * 10	jvm.classes.unloaded	未加载的classes数
 * 11	jvm.gc.memory.allocated	GC时，年轻代分配的内存空间
 * 12	jvm.gc.memory.promoted	GC时，老年代分配的内存空间
 * 13	jvm.gc.max.data.size	GC时，老年代的最大内存空间
 * 14	jvm.gc.live.data.size	FullGC时，老年代的内存空间
 * 15	jvm.gc.pause	GC耗时	是	显示在监控页面
 * ---	TOMCAT
 * 16	tomcat.sessions.created	tomcat已创建session数
 * 17	tomcat.sessions.expired	tomcat已过期session数
 * 18	tomcat.sessions.active.current	tomcat活跃session数
 * 19	tomcat.sessions.active.max	tomcat最多活跃session数
 * 20	tomcat.sessions.alive.max.second	tomcat最多活跃session数持续时间
 * 21	tomcat.sessions.rejected	超过session最大配置后，拒绝的session个数
 * 22	tomcat.global.error	错误总数
 * 23	tomcat.global.sent	发送的字节数
 * 24	tomcat.global.request.max	request最长时间
 * 25	tomcat.global.request	全局request次数和时间
 * 26	tomcat.global.received	全局received次数和时间
 * 27	tomcat.servlet.request	servlet的请求次数和时间
 * 28	tomcat.servlet.error	servlet发生错误总数
 * 29	tomcat.servlet.request.max	servlet请求最长时间
 * 30	tomcat.threads.busy	tomcat繁忙线程
 * 31	tomcat.threads.current	tomcat当前线程数（包括守护线程）
 * 32	tomcat.threads.config.max	tomcat配置的线程最大数
 * 33	tomcat.cache.access	tomcat读取缓存次数
 * 34	tomcat.cache.hit	tomcat缓存命中次数
 * ---	CPU
 * 35	system.cpu.count	CPU数量
 * 36	system.load.average.1m	load average
 * 37	system.cpu.usage	系统CPU使用率
 * 38	process.cpu.usage	当前进程CPU使用率
 * 39	http.server.requests	http请求调用情况
 * 40	process.uptime	应用已运行时间
 * 41	process.files.max	允许最大句柄数
 * 42	process.start.time	应用启动时间点
 * 43	process.files.open	当前打开句柄数
 */
@RestController
@RequestMapping("/monitor/actuatorSystem/v1")
@Api(tags = "系统监控")
@ApiGroup(group= {ApiGroupConsts.GROUP_SYSTEM})
public class ActuatorController extends BaseController {

    @Autowired
    private ActuatorSystemService actuatorSystemService;
    /**
     * Redis详细信息
     * @return
     * @throws Exception
     */
    @GetMapping("/httpTrace")
    @ApiOperation("请求追踪")
    public List<TraceInfo> gethttpTrace() throws IOException {
        return actuatorSystemService.getHttpTrace();
    }

    /**
     * tomcat
     * @return
     * @throws Exception
     */
    @GetMapping("/tomcat")
    @ApiOperation("tomcat监控")
    public List<ActuatorInfo> getTomcat() throws IOException {
        return actuatorSystemService.getMetrics("tomcat");
    }

    @GetMapping("/jvm")
    @ApiOperation("jvm监控")
    public List<ActuatorInfo> getJvm() throws IOException {
        return actuatorSystemService.getMetrics("jvm");
    }

    @GetMapping("/cpu")
    @ApiOperation("cpu监控")
    public List<ActuatorInfo> getCpu() throws IOException {
        return actuatorSystemService.getMetrics("system");
    }

    @GetMapping("/process")
    @ApiOperation("process监控")
    public List<ActuatorInfo> getProcess() throws IOException {
        return actuatorSystemService.getMetrics("process");
    }

    @GetMapping("/health")
    @ApiOperation("组件健康监控")
    public Map<String,String> getHealth() throws IOException {
        return actuatorSystemService.getHealth();
    }
}
