package com.artfess.form.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.form.model.ViewManage;
import com.artfess.form.persistence.manager.ViewManageManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

/**
 * 
 * <pre> 
 * 描述：视图管理 控制器类
 * 构建组：x7
 * 作者:pangq
 * 邮箱:pangq@jee-soft.cn
 * 日期:2020-04-30 17:01:50
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@RestController
@RequestMapping(value="/form/viewManage/v1")
@Api(tags="viewManageController")
@ApiGroup(group= {ApiGroupConsts.GROUP_FORM})
public class ViewManageController extends BaseController<ViewManageManager,ViewManage>{
	@Resource
	ViewManageManager viewManageManager;
	
	/**
	 * 视图管理列表(分页条件查询)数据
	 * @param queryFilter
	 * @return
	 * @throws Exception 
	 * PageJson
	 * @exception 
	 */
	@PostMapping("/listJson")
	@ApiOperation(value="视图管理数据列表", httpMethod = "POST", notes = "获取视图管理列表")
	public PageList<ViewManage> list(@ApiParam(name="queryFilter",value="查询对象")@RequestBody QueryFilter<ViewManage> queryFilter) throws Exception{
		List<FieldSort> sorter = queryFilter.getSorter();
		sorter.add(new FieldSort("ID_", Direction.DESC));
		queryFilter.setSorter(sorter);
		return viewManageManager.query(queryFilter);
	}
	
	/**
	 * 视图管理明细页面
	 * @param id
	 * @return
	 * @throws Exception 
	 * ModelAndView
	 */
	@GetMapping(value="/getJson")
	@ApiOperation(value="视图管理数据详情",httpMethod = "GET",notes = "视图管理数据详情")
	public ViewManage get(@ApiParam(name="id",value="业务对象主键", required = true)@RequestParam String id) throws Exception{
		return viewManageManager.get(id);
	}
	
    /**
	 * 新增视图管理
	 * @param viewManage
	 * @param saveType 保存类型：0仅保存，1保存并创建视图
	 * @throws Exception 
	 * @return
	 * @exception 
	 */
	@PostMapping(value="/save/{saveType}")
	@ApiOperation(value = "新增,更新视图管理数据", httpMethod = "POST", notes = "新增,更新视图管理数据")
	public CommonResult<String> save(@ApiParam(name="viewManage",value="视图管理业务对象", required = true)@RequestBody ViewManage viewManage,
			@PathVariable Integer saveType) throws Exception{
		String msg = "操作成功";
		viewManageManager.savePub(viewManage,saveType);
		return new CommonResult<String>(msg);
	}
	
	/**
	 * 生成视图
	 * @throws Exception 
	 * @return
	 * @exception 
	 */
	@GetMapping(value="/createPhysicalView/{id}")
	@ApiOperation(value = "新增,更新视图管理数据", httpMethod = "POST", notes = "新增,更新视图管理数据")
	public CommonResult<String> createPhysicalView(@PathVariable String id) throws Exception{
		viewManageManager.createPhysicalView(id);
		String msg = "操作成功";
		return new CommonResult<String>(msg);
	}
	
	/**
	 * 批量删除视图管理记录
	 * @param ids
	 * @throws Exception 
	 * @return
	 * @exception 
	 */
	@DeleteMapping(value="/remove")
	@ApiOperation(value = "批量删除视图管理记录", httpMethod = "DELETE", notes = "批量删除视图管理记录")
	public CommonResult<String> removes(@ApiParam(name="ids",value="业务主键数组,多个业务主键之间用逗号分隔", required = true)@RequestParam String...ids) throws Exception{
		viewManageManager.removeByIds(ids);
		return new CommonResult<String>(true, "批量删除成功");
	}

	@RequestMapping(value="exportXml" ,method= RequestMethod.GET, produces = { "application/json; charset=utf-8" })
	@ApiOperation(value = "导出视图xml", httpMethod = "GET", notes = "导出视图xml")
	public void exportXml(HttpServletRequest request, HttpServletResponse response,
						  @ApiParam(name="ids",value="视图id", required = true) @RequestParam String ids) throws Exception {
		response.setContentType("APPLICATION/OCTET-STREAM");
		if (BeanUtils.isNotEmpty(ids)) {
			String[] stringsIds = ids.split(",");
			List<String> list = Arrays.asList(stringsIds);
			String zipName = "ht_viewManage_"+ DateFormatUtil.format(LocalDateTime.now(), "yyyy_MMdd_HHmmss");
			// 写XML
			Map<String, String> strXml = baseService.exportData(list);
			HttpUtil.downLoadFile(request, response, strXml,zipName);
		}
	}

	@RequestMapping(value = "import", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
	@ApiOperation(value = "视图导入", httpMethod = "POST", notes = "视图导入")
	public CommonResult<String> importData(MultipartHttpServletRequest request, HttpServletResponse response) throws Exception {
		try {
			baseService.importData(request.getFile("file"));
			CommonResult<String> message = new CommonResult<>("导入成功");
			// 视图 导入成功！
			LinkedHashSet<String> viewsSaved = ThreadMsgUtil.getMapMsg2("viewsSaved");
			// 视图 已存在故跳过！
			LinkedHashSet<String> viewsSkipped = ThreadMsgUtil.getMapMsg2("viewsSkipped");
			StringBuilder sb = new StringBuilder();
			if (BeanUtils.isNotEmpty(viewsSkipped)){
				sb.append("<div style='font-weight:bold;'>以下视图已存在故跳过：</div>");
				String msg =  String.format( "%s", String.join("", viewsSkipped));
				sb.append(msg);
			}
			String msg = sb.toString();
			if(StringUtil.isNotEmpty(msg)){
				message.setMessage(msg);
			}
			return message;
		} catch (Exception e) {
			return new CommonResult<>(false, "导入失败：" + e.getMessage());
		}
	}
}
