package com.artfess.base.util;

/**
 * 数字转换中文
 *
 * @author huangshuai
 * @date 2019/11/22 0022
 */

public class ConvertUtil {

    static final String[] num = {"零", "一", "二", "三", "四", "五", "六", "七", "八", "九"};
    static final String[] unit = {"", "十", "百", "千", "万", "十", "百", "千", "亿", "十", "百", "千"};
    private static dm.jdbc.util.ConvertUtil instance ;
    private ConvertUtil(){}
    public static synchronized dm.jdbc.util.ConvertUtil getInstance() {
        if (instance == null) {
            instance = new dm.jdbc.util.ConvertUtil();
        }
        return instance;
    }

    public static String intToChineseNum(Integer intNum) {
        intNum = intNum == null ? 0 : intNum;
        StringBuilder dst = new StringBuilder();
        int count = 0;
        if(intNum >= 10 && intNum < 20){
            dst.append("十");
            dst.append(num[intNum % 10]);
        }else{
            while(intNum > 0) {
                dst.insert(0, (num[intNum % 10] + unit[count]));
                intNum = intNum / 10;
                count++;
            }
        }
        return dst.toString().replaceAll("零[千百十]", "零").replaceAll("零+万", "万")
                .replaceAll("零+亿", "亿").replaceAll("亿万", "亿零")
                .replaceAll("零+", "零").replaceAll("零$", "");
    }

    public static void main(String[] args) {
        String s = intToChineseNum(1);
        System.out.println(s);
    }

}
