package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 操作权限
 */
@Getter
public enum OperationAuth {
    one("1", "浏览"),

    two("2", "下载"),

    three("3", "打印"),

    ;

    OperationAuth(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public static String getDesc(String type){
        if(StringUtils.isEmpty(type)){
            return null;
        }
        OperationAuth[] values = values();
        for (OperationAuth state : values) {
            if (state.getType().equals(type)) {
                return state.getDesc();
            }
        }
        return null;
    }
}
