package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 文件后缀枚举类
 * @since 2022.10.25
 * @author min.wu
 */
@Getter
public enum FileTypeEnum {

	/**
	 * 视频
	 */
	video("1", ".mp4|.avi|.flv|.3gp|.mts", "视频"),

	/**
	 * 文本
	 */
	txt("2", ".txt|.pdf|.word|.xls|.xlsx|.docx|.doc|.wps|.et", "文档"),

	/**
	 * 图像
	 */
	img("3", ".jpeg|.png|.jpg|.gif|.bmp", "图片"),



	/**
	 * 音频
	 */
	audio("4", ".mp3|.wma|.aac", "音频"),


	/**
	 * 其他
	 */
	other("5", "", "其他"),

	;

	FileTypeEnum(String type, String desc, String name){
		this.type = type;
		this.desc = desc;
		this.name = name;
	}

	private String type;
	/**
	 * 文件后缀名
	 */
	private String desc;

	private String name;

	public static String getDesc(String type){
		if(StringUtils.isEmpty(type)){
			return null;
		}
		FileTypeEnum[] values = values();
		for (FileTypeEnum state : values) {
			if (state.getType().equals(type)) {
				return state.getName();
			}
		}
		return null;
	}

	public static String getType(String desc){
		if(StringUtils.isEmpty(desc)){
			return null;
		}
		FileTypeEnum[] values = values();
		for (FileTypeEnum state : values) {
			if (state.getDesc().contains(desc)) {
				return state.getType();
			}
		}
		return null;
	}

	public static String getName(String desc){
		if(StringUtils.isEmpty(desc)){
			return null;
		}
		FileTypeEnum[] values = values();
		for (FileTypeEnum state : values) {
			if (state.getDesc().contains(desc)) {
				return state.getName();
			}
		}
		return null;
	}

}
