/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.conf;

import com.artfess.base.annotation.ApiGroup;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import springfox.documentation.RequestHandler;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.ApiSelectorBuilder;
import springfox.documentation.spring.web.plugins.Docket;

public abstract class SwaggerConfigHelper
implements WebMvcConfigurer {
    @Value(value="${spring.profiles.title}")
    private String title;
    @Value(value="${spring.profiles.description}")
    private String description;
    @Value(value="${spring.profiles.version}")
    private String version;
    @Value(value="${file.upload}")
    private String upLoadPath;

    public Docket buildProductApi(String apiGroupName, String apiGroupKey) {
        Docket docket = this.buildDocket(apiGroupName).apiInfo(this.buildBaseProductApiInfo());
        ApiSelectorBuilder builder = this.buildApiForGroupKey(docket, apiGroupKey);
        return this.buildApiSecurityAuth(builder);
    }

    public Docket buildDocket(String apiGroupName) {
        return new Docket(DocumentationType.SWAGGER_2).groupName(apiGroupName).useDefaultResponseMessages(false).forCodeGeneration(false);
    }

    public ApiSelectorBuilder buildApiForGroupKey(Docket docket, String apiGroupKey) {
        return docket.select().apis(this.getPredicateWithGroup(apiGroupKey)).paths(PathSelectors.any());
    }

    public ApiSelectorBuilder buildApiForPackage(Docket docket, String basePackage) {
        return docket.select().apis(RequestHandlerSelectors.basePackage((String)basePackage)).paths(PathSelectors.any());
    }

    public Docket buildApiSecurityAuth(ApiSelectorBuilder builder) {
        return builder.build().securityContexts((List)Lists.newArrayList((Object[])new SecurityContext[]{this.buildSecurityContext()})).securitySchemes((List)Lists.newArrayList((Object[])new ApiKey[]{this.apiSecurityKey()}));
    }

    private ApiKey apiSecurityKey() {
        return new ApiKey("BearerToken", "Authorization", "header");
    }

    private SecurityContext buildSecurityContext() {
        return SecurityContext.builder().securityReferences(this.defaultAuth()).forPaths(PathSelectors.regex((String)"/.*")).build();
    }

    private List<SecurityReference> defaultAuth() {
        AuthorizationScope authorizationScope = new AuthorizationScope("global", "accessEverything");
        AuthorizationScope[] authorizationScopes = new AuthorizationScope[]{authorizationScope};
        return Lists.newArrayList((Object[])new SecurityReference[]{new SecurityReference("BearerToken", authorizationScopes)});
    }

    protected Predicate<RequestHandler> getPredicateWithGroup(final String group) {
        return new Predicate<RequestHandler>(){

            public boolean apply(RequestHandler input) {
                Optional ApiGroup2 = input.findControllerAnnotation(ApiGroup.class);
                return ApiGroup2.isPresent() && Arrays.asList(((ApiGroup)ApiGroup2.get()).group()).contains(group);
            }
        };
    }

    protected ApiInfo buildBaseProductApiInfo() {
        Contact contact = new Contact("liangyan", "www.Artfess.com", "liangyan@artfess.com");
        return this.buildApiInfo(this.title, this.description, this.version, "http://127.0.0.1:8080", contact);
    }

    protected ApiInfo buildApiInfo(String title, String description, String version, String url, Contact contact) {
        ApiInfo apiInfo = new ApiInfo(title, description, version, url, contact, "license", "license url", new ArrayList());
        return apiInfo;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"swagger-ui.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"doc.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
        registry.addResourceHandler(new String[]{"/m3u8/**"}).addResourceLocations(new String[]{"file:" + this.upLoadPath + "/"});
    }
}

