package com.artfess.examine.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 统一任务表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
@Data
@ApiModel(value="ExamTask对象", description="统一任务表")
public class ExamTask extends AutoFillModel<ExamTask> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "考试计划id")
    @TableField("task_id_")
    private String taskId;

    @ApiModelProperty(value = "计划目标人")
    @TableField("receive_user_")
    private String receiveUser;

    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "排序（按照类型排序）")
    @TableField("sn_")
    private Integer sn;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

}
