package com.artfess.examine.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 课目岗位中间表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-11-07
 */
@Data
@ApiModel(value="ExamSubjectPos对象", description="课目岗位中间表")
public class ExamSubjectPos extends BaseModel<ExamSubjectPos> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "课目id")
    @TableField("subject_id_")
    private String subjectId;

    @ApiModelProperty(value = "组织id")
    @TableField("org_id_")
    private String orgId;

    @ApiModelProperty(value = "岗位id")
    @TableField("position_id_")
    private String positionId;

    @ApiModelProperty(value = "专业装备id")
    @TableField(exist = false)
    private String majorId;

    @ApiModelProperty(value = "查询id")
    @TableField("full_id_")
    private String fullId;

}
