package com.artfess.examine.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.FieldRepeat;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;

/**
 * 考试场地信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
@Data
@FieldRepeat(fields = {"code","name"},message = "设备名称或代码不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
@ApiModel(value="ExamRoomInfo对象", description="考试场地信息")
public class ExamRoomInfo extends AutoFillModel<ExamRoomInfo> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请输入考场编码",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "考场编码（唯一值）")
    @TableField("code_")
    private String code;


    @NotBlank(message = "请输入考场名称",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "考场名称")
    @TableField("name_")
    private String name;

    @ApiModelProperty(value = "考场位置")
    @TableField("room_place_")
    private String roomPlace;

    @ApiModelProperty(value = "考场状态【字典】（0：未使用，1：已预定，2：使用中）")
    @TableField("room_status_")
    private String roomStatus;

    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "排序（按照类型排序）")
    @TableField("sn_")
    private Integer sn;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

}
