package com.artfess.examine.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.FieldRepeat;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDateTime;

/**
 * 通知公告
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
@Data
@ApiModel(value="ExamNotice对象", description="通知公告")
@FieldRepeat(fields = {"title"},message = "公告标题不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
public class ExamNotice extends AutoFillModel<ExamNotice> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请输入公告标题",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "公告标题")
    @TableField("title_")
    private String title;

    @NotBlank(message = "请选择公告类型",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "公告类型【字典】(1.考试通知、系统公告)")
    @TableField("type_")
    private String type;

    @NotBlank(message = "请输入公告内容",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "公告内容")
    @TableField("content_")
    private String content;

    @ApiModelProperty(value = "公告状态【字典】（0正常1关闭）")
    @TableField("status")
    private String status = "0";

    @ApiModelProperty(value = "截止日期")
    @TableField("end_time_")
    private LocalDateTime endTime;

    @ApiModelProperty(value = "是否置顶,0：不置顶，1：置顶 ")
    @TableField("top_status_")
    private String topStatus;

    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "排序（按照类型排序）")
    @TableField("sn_")
    private Integer sn;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

}
