package com.artfess.examine.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 资料授权表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
@Data
@ApiModel(value="ExamMaterialAuth对象", description="资料授权表")
public class ExamMaterialAuth extends BaseModel<ExamMaterialAuth> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "资料_ID")
    @TableField("material_id_")
    private String materialId;

    @ApiModelProperty(value = "权限受控类型（1：所有人  2：组织 3：用户）")
    @TableField("access_control_type_")
    private String accessControlType;

    @ApiModelProperty(value = "受控ID (用户ID或组织ID)")
    @TableField("access_control_id_")
    private String accessControlId;

    @ApiModelProperty(value = "操作权限(查看、下载)")
    @TableField("auth_type_")
    private String authType;

    @ApiModelProperty(value = "受控名称")
    @TableField("access_control_name_")
    private String accessControlName;

}
