package com.artfess.examine.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.examine.vo.PositionVo;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.util.List;

/**
 * 装备系统表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
@Data
@ApiModel(value="ExamEquipmentSys对象", description="装备系统表")
public class ExamEquipmentSys extends AutoFillModel<ExamEquipmentSys>{

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @Excel(name = "名称", column = "A")
    @NotBlank(message = "请输入名称",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "名称")
    @TableField("name_")
    private String name;

    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @Excel(name = "类型", column = "B")
    @ApiModelProperty(value = "类型 ，1：专业、2：装备")
    @TableField("type_")
    private String type;


    @Excel(name = "人员类别", column = "C")
    @ApiModelProperty(value = "人员类别id")
    @TableField("user_type_id")
    private String userTypeId;

    @Excel(name = "所属岗位", column = "D")
    @ApiModelProperty(value = "所属岗位")
    @TableField(exist = false)
    private String positonNames;

    @Excel(name = "所属组织", column = "F")
    @ApiModelProperty(value = "所属组织")
    @TableField(exist = false)
    private String orgName;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "排序（按照类型排序）")
    @TableField("sn_")
    private Integer sn;

    @ApiModelProperty(value = "岗位信息")
    @TableField(exist = false)
    private List<PositionVo> PositonVos;

    @ApiModelProperty(value = "科目id")
    @TableField(exist = false)
    private String subjectId;

}
