package com.artfess.examine.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.examine.dao.ExamRoomInfoDao;
import com.artfess.examine.manager.ExamRoomInfoManager;
import com.artfess.examine.model.ExamRoomInfo;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;

/**
 * 考试场地信息 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
@Service
public class ExamRoomInfoManagerImpl extends BaseManagerImpl<ExamRoomInfoDao, ExamRoomInfo> implements ExamRoomInfoManager {

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean modifyStatus(ExamRoomInfo t) {
        ExamRoomInfo entity = getById(t.getId());
        if (null == entity) {
            return false;
        }

        entity.setRoomStatus(t.getRoomStatus());
        entity.setUpdateTime(LocalDateTime.now());
        boolean b = this.saveOrUpdate(entity);
        return b;
    }
}
