package com.artfess.examine.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.examine.model.ExamPaperBase;
import com.artfess.examine.model.ExamUserRecord;
import com.artfess.examine.vo.*;

import java.util.List;

/**
 * 考生考试记录（人员考试成绩） 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
public interface ExamUserRecordManager extends BaseManager<ExamUserRecord> {

    List<QuestionsInfoVo> getQuestionList(ExamReqVo reqVo);

    void saveScore(SubmitAnswerReqVo reqVo);

    ExamPaperBase findByMyRecord(String id);

    MyExamInfoVo startExam(ExamReqVo reqVo);

    void submitAnswer(SubmitAnswerReqVo vo);

    List<UserInfoVo> findByPaperId(String id);

    PageList<ExamUserRecord> myPaper(QueryFilter<ExamUserRecord> queryFilter);

    MyExamInfoVo getUserRecord(String id);

    void switchCount(String id);

    void applyExamPaper(String id);

    boolean modifyStatus(ApplyPaperReqVo reqVo);

    PageList<PaperStatisticalVo> paperStatistical(QueryFilter<ExamPaperBase> queryFilter);

    PaperAnalysisVo paperAnalysis();

    JobStatisticalVo jobStatistical();

    void updateStatus(String id);

    PageList<ExamUserRecord> detailPage(QueryFilter<ExamUserRecord> queryFilter);

    MyExamInfoVo myPaperInfo(String id);

    /**
     * 根据用户ID获取年度考核的科目成绩
     *
     * @param userId 用户ID
     * @return 年度考核的科目成绩
     */
    List<YearSubjectScoreVO> getYearSubjectScore(String userId,Integer year);
}
