package com.artfess.examine.manager;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.manager.BaseManager;
import com.artfess.examine.model.ExamEquipmentSys;
import com.artfess.examine.model.ExamSubjectInfo;
import com.artfess.examine.model.ExamSubjectType;
import com.artfess.examine.vo.PositionVo;

import java.util.List;

/**
 * 装备系统表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
public interface ExamEquipmentSysManager extends BaseManager<ExamEquipmentSys> {

    /**
     * 获取装备系统下拉树
     * @param entity
     * @return
     */
    List<ExamSubjectType> getTree(ExamEquipmentSys entity);

    void bindPosAndUserType(ExamEquipmentSys entity);

    List<PositionVo> findByBindPos(String id);

    boolean createInfo(ExamEquipmentSys t);

    boolean updateInfo(ExamEquipmentSys t);

    ExamEquipmentSys findById(String id);

    boolean importExcel(List<ExamEquipmentSys> list);

    List<ExamSubjectInfo> getSubjectList(List<String> idList);

    JSONObject summary();
}
