package com.artfess.examine.dao;

import com.alibaba.fastjson.JSONObject;
import com.artfess.examine.model.ExamEquipmentSys;
import com.artfess.examine.model.ExamSubjectInfo;
import com.artfess.examine.model.ExamSubjectType;
import com.artfess.examine.vo.PositionVo;
import com.artfess.examine.vo.SubjectReqVo;
import com.artfess.examine.vo.UserInfoVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 训练考试科目 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
public interface ExamSubjectInfoDao extends BaseMapper<ExamSubjectInfo> {

    List<ExamSubjectType> getTree(@Param("vo") ExamSubjectInfo entity);

    List<ExamSubjectInfo> findByMajorIds(@Param("vo") SubjectReqVo t);

    List<PositionVo> getPositionInfo(@Param("id") String id);

    IPage<ExamSubjectInfo> queryPage(IPage<ExamSubjectInfo> convert2IPage, @Param(Constants.WRAPPER) Wrapper<ExamSubjectInfo> convert2Wrapper);

    List<UserInfoVo> getSubjectUserList(@Param("vo") SubjectReqVo t);

    List<ExamEquipmentSys> findBySubjectId(@Param("id") String id);

    IPage<ExamSubjectInfo> notSubjectPage(IPage<ExamSubjectInfo> convert2IPage, @Param(Constants.WRAPPER) Wrapper<ExamSubjectInfo> convert2Wrapper,
                                          @Param("vo") Map<String, Object> params);

    String getuserTypeId(String userTypeId);

    List<String> getPositionIds(@Param("names") List<String> split);

    int getSubjectCount(@Param("name") String name, @Param("positionIds") List<String> positionIds,
                        @Param("majorIds") List<String> majorIds, @Param("id") String id);

    List<ExamEquipmentSys> findBySubjectIds(@Param("subjectIds") List<String> subjectIds);

    ExamSubjectInfo findBySubject(@Param("subjectName") String subjectName, @Param("majorName") String majorName, @Param("positionName") String positionName);

    List<JSONObject> getSubjectList(@Param("vo") ExamSubjectInfo entity);

    List<ExamSubjectType> getOrgList();

    List<ExamSubjectType> getExamSysInfo();

    List<ExamSubjectType> getPositions();

    String getPositionId(@Param("orgId") String orgId, @Param("positonNames") String positonNames);

    IPage<UserInfoVo> coachSubjectList(IPage<ExamSubjectInfo> convert2IPage,@Param(Constants.WRAPPER) Wrapper<ExamSubjectInfo> convert2Wrapper);
}
