package com.artfess.examine.dao;

import com.alibaba.fastjson.JSONObject;
import com.artfess.examine.model.ExamQuestionsInfo;
import com.artfess.examine.vo.SubjectQuestionTypeVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 题库试题信息 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
public interface ExamQuestionsInfoDao extends BaseMapper<ExamQuestionsInfo> {

    List<ExamQuestionsInfo> randomQuestion(@Param("subjectId") String subjectId, @Param("questionType") String questionType, @Param("numuber") Integer numuber);

    List<SubjectQuestionTypeVo> findBySubjectId(@Param("subjectId") String subjectId);

    IPage<ExamQuestionsInfo> findByPage(IPage<ExamQuestionsInfo> convert2IPage, @Param(Constants.WRAPPER) Wrapper<ExamQuestionsInfo> convert2Wrapper);

    List<SubjectQuestionTypeVo> selectTypeCount();

    List<JSONObject> selectDifficulty();


}
