package com.artfess.data.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 考生训练计划
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-11-14
 */
@Data
@ApiModel(value="BizUserTrainPlan对象", description="考生训练计划")
public class BizUserTrainPlan extends AutoFillModel<BizUserTrainPlan> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotNull(message = "请选择计划", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "计划id")
    @TableField("plan_id_")
    private String planId;

    @ApiModelProperty(value = "单位id")
    @TableField("org_id_")
    private String orgId;

    @Excel(name = "单位", column = "A")
    @ApiModelProperty(value = "单位")
    @TableField("org_name_")
    private String orgName;

    @NotNull(message = "请选择考生", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "考生id")
    @TableField("user_id_")
    private String userId;

    @Excel(name = "考生名称", column = "B")
    @ApiModelProperty(value = "考生")
    @TableField("user_name_")
    private String userName;

    @Excel(name = "训练成绩", column = "D")
    @ApiModelProperty(value = "训练成绩")
    @TableField("score_")
    private BigDecimal score;

    @Excel(name = "训练时长", column = "C")
    @NotNull(message = "请填写训练时长", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "训练时长")
    @TableField("hour_")
    private BigDecimal hour;

    @ApiModelProperty(value = "训练文件（图片或视屏，文件以json格式存储）")
    @TableField("train_file_")
    private String trainFile;

    @ApiModelProperty(value = "训练状态(0未训练、1：训练中、2：已完成)")
    @TableField("status_")
    private String status;

    @Excel(name = "备注", column = "E")
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "数据时间戳")
    @TableField(updateStrategy=FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=true)
    private LocalDateTime lastTime;

}
