package com.artfess.data.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 个人信息基本情况表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 超级管理员
 * @since 2024-12-27
 */
@Setter
@Getter
@ApiModel(value="BizUserBasic对象", description="个人信息基本情况表")
public class BizUserBasic extends AutoFillModel<BizUserBasic> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID_")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "系统人员ID")
    @TableField("user_id_")
    private String userId;

    @ApiModelProperty(value = "系统登录账号")
    @TableField("login_name_")
    private String loginName;

    @ApiModelProperty(value = "个人档案编号（唯一值）")
    @TableField("user_archive_")
    private String userArchive;

    @ApiModelProperty(value = "建档单位名称")
    @TableField("archive_unit_name_")
    private String archiveUnitName;

    @ApiModelProperty(value = "建档年月（格式：2024年12月）")
    @TableField("archive_year_")
    private LocalDate archiveYear;

    @ApiModelProperty(value = "人员档案姓名")
    @TableField("user_name_")
    private String userName;

    @ApiModelProperty(value = "性别")
    @TableField("sex_")
    private String sex;

    @ApiModelProperty(value = "身份证号")
    @TableField("ident_card_")
    private String identCard;

    @ApiModelProperty(value = "电话号码")
    @TableField("phone_num_")
    private String phoneNum;

    @ApiModelProperty(value = "出生日期")
    @TableField("birth_date_")
    private LocalDate birthDate;

    @ApiModelProperty(value = "入伍时间")
    @TableField("rw_date_")
    private LocalDate rwDate;

    @ApiModelProperty(value = "现军衔时间")
    @TableField("xjx_date_")
    private String xjxDate;

    @ApiModelProperty(value = "职务描述")
    @TableField("job_description_")
    private String jobDescription;

    @ApiModelProperty(value = "入党时间")
    @TableField("rd_date_")
    private LocalDate rdDate;

    @ApiModelProperty(value = "民族")
    @TableField("nation_")
    private String nation;

    @ApiModelProperty(value = "籍贯")
    @TableField("native_place_")
    private String nativePlace;

    @ApiModelProperty(value = "政治面貌")
    @TableField("political_outlook_")
    private String politicalOutlook;

    @ApiModelProperty(value = "血型")
    @TableField("blood_type_")
    private String bloodType;

    @ApiModelProperty(value = "入伍地地址")
    @TableField("rw_address_")
    private String rwAddress;

    @ApiModelProperty(value = "户籍所在地")
    @TableField("registered_residence_")
    private String registeredResidence;

    @ApiModelProperty(value = "学历学位(字典)")
    @TableField("high_education_")
    private String highEducation;

    @ApiModelProperty(value = "人员类别")
    @TableField("user_class_")
    private String userClass;

    @ApiModelProperty(value = "个人照片地址（URL地址）")
    @TableField("user_photo_url_")
    private String userPhotoUrl;

    @ApiModelProperty(value = "创建人")
    @TableField("create_by_")
    private String createBy;

    @ApiModelProperty(value = "创建单位")
    @TableField("create_org_id_")
    private String createOrgId;

    @ApiModelProperty(value = "创建时间")
    @TableField("create_time_")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "修改人员")
    @TableField("update_by_")
    private String updateBy;

    @ApiModelProperty(value = "修改时间")
    @TableField("update_time_")
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "删除标记（1已删除，0未删除）")
    @TableField("is_dele_")
    private String isDele;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizUserBasic{" +
            "id=" + id +
            ", userId=" + userId +
            ", loginName=" + loginName +
            ", userArchive=" + userArchive +
            ", archiveUnitName=" + archiveUnitName +
            ", archiveYear=" + archiveYear +
            ", userName=" + userName +
            ", sex=" + sex +
            ", identCard=" + identCard +
            ", phoneNum=" + phoneNum +
            ", birthDate=" + birthDate +
            ", rwDate=" + rwDate +
            ", xjxDate=" + xjxDate +
            ", jobDescription=" + jobDescription +
            ", rdDate=" + rdDate +
            ", nation=" + nation +
            ", nativePlace=" + nativePlace +
            ", politicalOutlook=" + politicalOutlook +
            ", bloodType=" + bloodType +
            ", rwAddress=" + rwAddress +
            ", registeredResidence=" + registeredResidence +
            ", highEducation=" + highEducation +
            ", userClass=" + userClass +
            ", userPhotoUrl=" + userPhotoUrl +
            ", createBy=" + createBy +
            ", createOrgId=" + createOrgId +
            ", createTime=" + createTime +
            ", updateBy=" + updateBy +
            ", updateTime=" + updateTime +
            ", isDele=" + isDele +
        "}";
    }
}
