package com.artfess.data.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

/**
 * 指挥控制数据
 *
 * @author min.wu
 * @company 阿特菲斯信息技术有限公司
 * @since 2024-09-02
 */
@Data
@ApiModel(value = "BizControlData对象", description = "指挥控制数据")
public class BizControlData extends AutoFillModel<BizControlData> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotNull(message = "请填写单位", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "单位id")
    @TableField("org_id_")
    private String orgId;

    @Excel(name = "单位", column = "A")
    @ApiModelProperty(value = "单位")
    @TableField("org_name_")
    private String orgName;

    @Excel(name = "侦察情报", column = "B")
    @ApiModelProperty(value = "侦察情报")
    @TableField("inspect_")
    private String inspect;

    @Excel(name = "作战计划", column = "C")
    @ApiModelProperty(value = "作战计划")
    @TableField("operationp_plan_")
    private String operationpPlan;

    @Excel(name = "作战控制", column = "D")
    @ApiModelProperty(value = "作战控制")
    @TableField("operation_control_")
    private String operationControl;

    @Excel(name = "政治工作", column = "E")
    @ApiModelProperty(value = "政治工作")
    @TableField("political_work_")
    private String politicalWork;

    @Excel(name = "后装保障", column = "F")
    @ApiModelProperty(value = "后装保障")
    @TableField("afterloading_support_")
    private String afterloadingSupport;

    @Excel(name = "备注", column = "G")
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "排序（按照类型排序）")
    @TableField("sn_")
    private Integer sn;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "数据时间戳")
    @TableField(updateStrategy = FieldStrategy.NOT_NULL, value = "last_time_", fill = FieldFill.INSERT_UPDATE, select = true)
    private LocalDateTime lastTime;
}
