package com.artfess.data.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.data.dao.BizUserCheckDao;
import com.artfess.data.manager.BizExamPlanManager;
import com.artfess.data.manager.BizUserCheckManager;
import com.artfess.data.model.BizExamPlan;
import com.artfess.data.model.BizUserCheck;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 人员考勤数据 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-09-02
 */
@Service
public class BizUserCheckManagerImpl extends BaseManagerImpl<BizUserCheckDao, BizUserCheck> implements BizUserCheckManager {

    @Autowired
    private BizExamPlanManager examPlanManager;

    @Override
    public void importList(List<BizUserCheck> list, String planId) {
        Assert.hasText(planId, "请选择要考勤的训练计划");
        BizExamPlan bizExamPlan = examPlanManager.get(planId);
        Assert.notNull(bizExamPlan, "训练课目不存在");

        QueryWrapper<BizUserCheck> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("is_dele_", DelStatusEnum.N.getType());
        queryWrapper.eq("plan_id_", planId);
        List<BizUserCheck> userChecks = this.list(queryWrapper);
        List<BizUserCheck> updateUsers = Lists.newArrayList();

        Map<String, List<BizUserCheck>> dMap = userChecks.stream().collect(Collectors.groupingBy(BizUserCheck::getUserName));
        list.forEach(baseData -> {
            Assert.notNull(baseData.getCheckDate(), "请填写考勤日期");
            Assert.hasText(baseData.getUserName(), "请填写考生信息");
            if(CollectionUtils.isEmpty(dMap) || null == dMap.get(baseData.getUserName())) {
                return;
            }
            List<BizUserCheck> userCheckList = dMap.get(baseData.getUserName());
            Map<String, BizUserCheck> detailMap = userCheckList.stream().collect(Collectors.toMap(item -> item.getCheckDate(), item -> item));
            if(null != detailMap && null != detailMap.get(baseData.getCheckDate())){
                BizUserCheck userCheck = detailMap.get(baseData.getCheckDate());
                userCheck.setStatus("1");
                updateUsers.add(userCheck);
            }
        });
        if(!CollectionUtils.isEmpty(updateUsers)) {
            this.saveOrUpdateBatch(updateUsers);
        }

    }

    @Override
    public PageList<BizUserCheck> findByPage(QueryFilter<BizUserCheck> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<BizUserCheck> result = baseMapper.findByPage(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }
}
