/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.examine.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.enums.AccessControlTypeEnum;
import com.artfess.base.enums.FileTypeEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.AuthenticationUtil;
import com.artfess.examine.dao.ExamFileDao;
import com.artfess.examine.dao.ExamMaterialInfoDao;
import com.artfess.examine.manager.ExamMaterialInfoManager;
import com.artfess.examine.manager.ExamMaterialTypeAuthManager;
import com.artfess.examine.model.ExamFile;
import com.artfess.examine.model.ExamMaterialInfo;
import com.artfess.examine.vo.ExamMaterialVo;
import com.artfess.file.util.FileUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ExamMaterialInfoManagerImpl
extends BaseManagerImpl<ExamMaterialInfoDao, ExamMaterialInfo>
implements ExamMaterialInfoManager {
    @Resource
    private ExamFileDao examFileDao;
    @Autowired
    private ExamMaterialTypeAuthManager materialTypeAuthManager;
    @Resource
    BaseContext baseContext;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String createInfo(ExamMaterialInfo t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"type_id_", (Object)t.getTypeId());
        queryWrapper.eq((Object)"title_", (Object)t.getTitle());
        List examMaterialInfos = ((ExamMaterialInfoDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)examMaterialInfos)) {
            throw new RuntimeException("\u8be5\u5206\u7c7b\u4e0b\u8d44\u6599\u540d\u79f0\u5df2\u91cd\u590d\uff01");
        }
        int insert = ((ExamMaterialInfoDao)this.baseMapper).insert((Object)t);
        if (insert > 0) {
            this.processFile(t.getExamFiles(), t.getId());
            ExamMaterialVo examMaterialVo = t.getExamMaterialVo();
            examMaterialVo.setMaterialId(t.getId());
            this.materialTypeAuthManager.saveAuth(examMaterialVo);
            return t.getId();
        }
        return null;
    }

    private void processFile(List<ExamFile> examFiles, String id) {
        if (CollectionUtils.isEmpty(examFiles)) {
            return;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"material_id_", (Object)id);
        this.examFileDao.delete((Wrapper)queryWrapper);
        examFiles.forEach(examFile -> {
            examFile.setMaterialId(id);
            String suffixName = FileUtils.getSuffixFromFileName((String)examFile.getFileName());
            examFile.setFileExt(suffixName);
            String fileType = FileTypeEnum.getType((String)suffixName);
            examFile.setFileType(fileType);
            BigDecimal fileSize = examFile.getFileSizes().divide(new BigDecimal(1024), 2, 4);
            examFile.setFileSizes(fileSize);
            this.examFileDao.insert(examFile);
        });
    }

    @Override
    public String updateInfo(ExamMaterialInfo t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"type_id_", (Object)t.getTypeId());
        queryWrapper.eq((Object)"title_", (Object)t.getTitle());
        queryWrapper.ne((Object)"id_", (Object)t.getId());
        List examMaterialInfos = ((ExamMaterialInfoDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)examMaterialInfos)) {
            throw new RuntimeException("\u8be5\u5206\u7c7b\u4e0b\u8d44\u6599\u540d\u79f0\u5df2\u91cd\u590d\uff01");
        }
        this.processFile(t.getExamFiles(), t.getId());
        int insert = ((ExamMaterialInfoDao)this.baseMapper).updateById((Object)t);
        if (insert > 0) {
            ExamMaterialVo examMaterialVo = t.getExamMaterialVo();
            examMaterialVo.setMaterialId(t.getId());
            this.materialTypeAuthManager.saveAuth(examMaterialVo);
            return t.getId();
        }
        return null;
    }

    @Override
    public PageList<ExamMaterialInfo> findByPage(QueryFilter<ExamMaterialInfo> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<ExamMaterialInfo> result = ((ExamMaterialInfoDao)this.baseMapper).queryPage((IPage<ExamMaterialInfo>)this.convert2IPage(pageBean), (Wrapper<ExamMaterialInfo>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public ExamMaterialInfo findById(String id) {
        ExamMaterialInfo examMaterialInfo = (ExamMaterialInfo)((Object)((ExamMaterialInfoDao)this.baseMapper).selectById((Serializable)((Object)id)));
        if (null == examMaterialInfo) {
            return new ExamMaterialInfo();
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"material_id_", (Object)id);
        List examFiles = this.examFileDao.selectList((Wrapper)queryWrapper);
        examMaterialInfo.setExamFiles(examFiles);
        ExamMaterialVo byTypeId = this.materialTypeAuthManager.findByTypeId(id);
        examMaterialInfo.setExamMaterialVo(byTypeId);
        return examMaterialInfo;
    }

    @Override
    public ExamMaterialInfo viewFile(String id) {
        ExamMaterialInfo examMaterialInfo = (ExamMaterialInfo)((Object)((ExamMaterialInfoDao)this.baseMapper).selectById((Serializable)((Object)id)));
        if (null == examMaterialInfo) {
            return new ExamMaterialInfo();
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"material_id_", (Object)id);
        List examFiles = this.examFileDao.selectList((Wrapper)queryWrapper);
        ExamMaterialVo byTypeId = this.materialTypeAuthManager.findByTypeId(id);
        if (AccessControlTypeEnum.ALL.getType().equals(byTypeId.getAccessControlType())) {
            examMaterialInfo.setExamFiles(examFiles);
        } else if (AccessControlTypeEnum.ORG.getType().equals(byTypeId.getAccessControlType())) {
            String createOrgId = this.baseContext.getCurrentOrgId();
            AtomicBoolean flag = new AtomicBoolean(false);
            byTypeId.getAccessControlList().forEach(acc -> {
                if (createOrgId.equals(acc.getAccessControlId())) {
                    flag.set(true);
                }
            });
            if (flag.get()) {
                examMaterialInfo.setExamFiles(examFiles);
            }
        } else if (AccessControlTypeEnum.USER.getType().equals(byTypeId.getAccessControlType())) {
            String userId = AuthenticationUtil.getCurrentUserId();
            AtomicBoolean flag = new AtomicBoolean(false);
            byTypeId.getAccessControlList().forEach(acc -> {
                if (userId.equals(acc.getAccessControlId())) {
                    flag.set(true);
                }
            });
            if (flag.get()) {
                examMaterialInfo.setExamFiles(examFiles);
            }
        }
        return examMaterialInfo;
    }
}

