import req from '@/request'

const portal = window.context.portal

// 表格分页
export async function tableData(data) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/biz/archives/personArchives`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 导出
export function exportData(data = {}) {
  return new Promise((resolve, reject) => {
    req
      .post(
        portal + `/biz/archives/personArchives/exportWord`,
        data,
        'arraybuffer'
      )
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}
// 个人信息
export function personalProfile(year, userId) {
  return new Promise((resolve, reject) => {
    req
      .get(portal + `/biz/personalProfile/${year}/${userId}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}
// 编辑个人信息
export function savePersonInfo(data) {
  return new Promise((resolve, reject) => {
    req
      .put(portal + `/biz/personalProfile`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 编辑个人信息
export function getPersonInfo(data) {
  return new Promise((resolve, reject) => {
    req
      .get(portal + `/biz/personalProfile`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}
// 上传文件
export function uploadPhoto(data) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/biz/personalProfile/uploadImage`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}
// /download/{fileName}
export function download(fileName) {
  return new Promise((resolve, reject) => {
    req
      .get(portal + `/biz/personalProfile/download/${fileName}`, 'arraybuffer')
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}
// 获取用户年度科目成绩 /exam/user/record/getSubjectScore/{userId}/{year}
export function getSubjectScore(year, userId) {
  return new Promise((resolve, reject) => {
    req
      .get(portal + `/exam/user/record/getSubjectScore/${userId}/${year}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}
// 导出文档
export function downloadDoc(data) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/biz/personalProfile/export`, data, 'arraybuffer')
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}
