import req from '@/request'
import {createAutoCancelRequest} from '@/utils/helpers'

const portal = window.context.portal

// 系统用户列表
export function getOrgUserQuery(data = {}) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/api/user/v1/users/getOrgUserQuery`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 获取岗位下人员列表
export function getOrgUserPage(data = {}) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/api/org/v1/orgUsers/getOrgUserPage`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 岗位列表
export function getOrgPostPage(data) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/api/org/v1/orgPosts/getOrgPostPage`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 获得单位树
export function orgTree() {
  return new Promise((resolve, reject) => {
    req
      .get(portal + `/api/org/v1/orgs/orgTree?demCode=xzwd`)
      .then(res => resolve(res.data || []))
      .catch(err => reject(err))
  })
}

// 获得组织树
export function treeDataByDem() {
  return new Promise((resolve, reject) => {
    req
      .get(portal + `/api/org/v1/orgs/treeDataByDem?demCode=xzwd`)
      .then(res => resolve(res.data || []))
      .catch(err => reject(err))
  })
}

// 获得组织列表
export function getOrgPage(data = {}) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/api/org/v1/orgs/getOrgPage`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 文件下载/预览
export function downloadFiles(fileId) {
  return new Promise((resolve, reject) => {
    req
      .get(portal + `/file/v1/downloadFile?fileId=${fileId}`, 'blob')
      .then(res => resolve(res || {}))
      .catch(err => reject(err))
  })
}

// 附件在线预览
export function onlinePreview(fileId = '') {
  return new Promise((resolve, reject) => {
    req
      .get(
        portal +
          `/file/onlinePreviewController/v1/onlinePreview?fileId=${fileId}`
      )
      .then(res => resolve(res.data || {}))
      .catch(err => reject(err))
  })
}

// 分片初始化
export function initFile(data) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/file/v1/init`, data, undefined, 0)
      .then(res => resolve(res.data || {}))
      .catch(err => reject(err))
  })
}

// 分片合并
export function completeUpload(uploadId) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/file/v1/completeUpload`, {uploadId}, undefined, 0)
      .then(res => resolve(res.data || {}))
      .catch(err => reject(err))
  })
}

// 获取公司树数据
export function queryCompanyData(data) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/api/org/v1/orgs/findByParamsOrgTree`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 获取人员类别专业装备下拉树
export function equipmentTree(data) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/exam/equipment/sys/getTree`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 获得课目树
export function getCourseTree() {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/exam/subject/info/getTree`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

/**
 * 通过中文获取编码
 * */
export const getCodeRequest = createAutoCancelRequest(
  `/base/tools/v1/getPinyin`
)
