import req from '@/request.js'
const portal = window.context.portal
export default {
    // 添加资料分类
    addMaterial(data, cb) {
        req.post(portal + `/exam/materialType/type/`, data).then(res => {
            cb(res.data)
        })
    },
    // 资料分类列表
    getMaterial(data, cb) {
        req.post(portal + `/exam/materialType/type/query`, data).then(res => {
            cb(res.data)
        })
    },
    // 获取资料分类下拉树
    getMaterTree(data, cb) {
        req.post(portal + `/exam/materialType/type/getTree`, data).then(res => {
            cb(res.data)
        })
    },
    // 修改资料分类
    editMaterial(data, cb) {
        req.put(portal + `/exam/materialType/type/`, data).then(res => {
            cb(res.data)
        })
    },
    // id查询资料分类
    detailId(id, cb) {
        req.get(portal + `/exam/materialType/type/` + id).then(rep => {
            cb(rep.data)
        })
    },
    // 删除单个
    deleteOneEqeSys(ids, cb) {
        return new Promise((resolve, reject) => {
            req.remove(portal + '/exam/materialType/type/' + ids).then(res => {
                resolve(res);
            }, error => {
                reject(error);
            })
        })
    },
    // 批量删除
    deleteEqeSys(ids, cb) {
        req.remove(portal + `/exam/materialType/type/?ids=` + ids).then(rep => {
            cb(rep.data)
        })
    },
}