import req from '@/request.js'
const portal = window.context.portal
export default {
    // 添加公告
    addNotice(data, cb) {
        req.post(portal + `/exam/notice/`, data).then(res => {
            cb(res.data)
        })
    },
    // 获取公告列表
    getNotice(data, cb) {
        req.post(portal + `/exam/notice/query`, data).then(res => {
            cb(res.data)
        })
    },
    //保存排序
    saveSort(data, cb) {
        req.post(portal + `/exam/notice/updateSequence`, data).then(res => {
            cb(res.data)
        })
    },
    // 公告是否置顶
    Noticeflag(data, cb) {
        req.post(portal + `/exam/notice/modifyTopStatus`, data).then(res => {
            cb(res.data)
        })
    },
    // 公告状态
    NoticeStatus(data, cb) {
        req.post(portal + `/exam/notice/modifyStatus`, data).then(res => {
            cb(res.data)
        })
    },
    // 修改公告信息
    editNotice(data, cb) {
        req.put(portal + `/exam/notice/`, data).then(res => {
            cb(res.data)
        })
    },
    // id查询公告
    detailId(id, cb) {
        req.get(task + `/exam/notice/` + id).then(rep => {
            cb(rep.data)
        })
    },
    // 删除单个
    deleteOneNotice(ids, cb) {
        return new Promise((resolve, reject) => {
            req.remove(portal + '/exam/notice/' + ids).then(res => {
                resolve(res);
            }, error => {
                reject(error);
            })
        })
    },
    // 批量删除
    deleteNotice(ids, cb) {
        req.remove(task + `/exam/notice/?ids=` + ids).then(rep => {
            cb(rep.data)
        })
    },
}