import req from '@/request.js'
const portal = window.context.portal
export default {
    // 获取所有授权对象
    getAllTypeId(id, cb) {
        req.get(portal + `/exam/materialType/auth/findByTypeId?typeId=` + id).then(rep => {
            cb(rep.data)
        })
    },
    // 授权保存
    saveGivePower(data, cb) {
        req.post(portal + `/exam/materialType/auth/saveOrUpdate`, data).then(res => {
            cb(res.data)
        })
    },
    // 获取科室列表
    getOrgsList(data, cb) {
        req.post(portal + `/api/org/v1/orgs/getOrgPage`, data).then(res => {
            cb(res.data)
        })
    },
	//获取组织
	getOrgPostPage(data, cb) {
	    req.post(portal + `/api/org/v1/orgPosts/getOrgPostPage`, data).then(res => {
	        cb(res.data)
	    })
	},
    // 获取用户列表
    getUsersList(data, cb) {
        req.post(portal + `/api/user/v1/users/queryByType`, data).then(res => {
            cb(res.data)
        })
    },
}