"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var util_1 = require("@antv/util");
var d3_linear_1 = require("../util/d3-linear");
var interval_1 = require("../util/interval");
var strict_limit_1 = require("../util/strict-limit");
function d3LinearTickMethod(cfg) {
    var min = cfg.min, max = cfg.max, tickInterval = cfg.tickInterval, minLimit = cfg.minLimit, maxLimit = cfg.maxLimit;
    var ticks = (0, d3_linear_1.default)(cfg);
    if (!(0, util_1.isNil)(minLimit) || !(0, util_1.isNil)(maxLimit)) {
        return (0, strict_limit_1.default)(cfg, (0, util_1.head)(ticks), (0, util_1.last)(ticks));
    }
    if (tickInterval) {
        return (0, interval_1.default)(min, max, tickInterval).ticks;
    }
    return ticks;
}
exports.default = d3LinearTickMethod;
//# sourceMappingURL=d3-linear.js.map