# matrix-util

> 扩展了 gl-matrx 的 vec2, vec3, mat3, transform 方法


## 安装下载

> tnpm i --save @antv/util

```js
// 所有的 api 是都这么引入，名字不同而已
import { vec2, vec3 } from '@antv/matrix-util';

vec2.angle(v1, v2);
```


## API 文档

> 推荐使用的 API 文档如下：
* vec2 新增了以下方法：
    + angle(v1, v2)
    + direction(v1, v2)
    + angleTo(v1, v2)
    + vertical(out, in) 求垂直向量
* vec3 未新增方法
* mat3 新增：
    + translate(out, m, v)
    + rotate(out, m, rad)
    + scale(out, m, v)
* transform(m, [])
```js
transform(m, [
    ['t', 100, 200],
    ['r', 40],
    ['s', 2, 2]
]);
```


