package com.artfess.file.params;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 系统附件配置存储信息DTO
 *
 * @author chenshi
 */
@ApiModel(value="FileStorageConfigDTO", description="系统附件配置存储信息")
public class FileStorageConfigDTO  {
	@ApiModelProperty(value = "ID_")
	private String id;

	@ApiModelProperty(value = "附件存储配置ID")
	private String storageId;

	@ApiModelProperty(value = "附件配置编码(唯一)")
	private String code;

	@ApiModelProperty(value = "附件配置名称")
	private String name;

	@ApiModelProperty(value = "附件上传大小（MB）")
	private Double allowSize;

	@ApiModelProperty(value = "是否允许删除（0：否，1：是）")
	private Integer allowDelete;

	@ApiModelProperty(value = "是否分片上传 0 否 1是")
	private Integer isZone;

	@ApiModelProperty(value = "是否允许同时上传多个（0：否，1：是）")
	private Integer allowMultiple;

	@ApiModelProperty(value = "允许上传附件类型")
	private String fileKinds;

	@ApiModelProperty(value = "备注")
	private String memo;

	@ApiModelProperty(value = "存储配置名称")
	protected String storageName;

	@ApiModelProperty(value = "存储配置编码（唯一）")
	protected String storageCode;

	@ApiModelProperty(value = "上传方式：可用参数值：database（保存在数据库）；folder（保存在服务器文件目录）；ftp（上传到ftp；aliyunOss（保存在阿里云OSS）；minio;huaweiObs(上传附件到华为云)")
	protected String uploadType;

	@ApiModelProperty(value = "文件存储位置, 可能是磁盘路径, 或者是FTP存储根目录, 或者是阿里云OSS 主目录 BucketName,或者是minio的桶名 BucketName，或者华为云的桶名 BucketName")
	protected String location;

	@ApiModelProperty(value = "ftp或者minio 上传地址")
	protected String url;

	@ApiModelProperty(value = "ftp或者minio 端口号")
	protected Integer port;

	@ApiModelProperty(value = "ftp或者minio 认证用户名")
	protected String userName;

	@ApiModelProperty(value = "ftp或者minio 认证用户密码")
	protected String password;

	@ApiModelProperty(value = "阿里云OSS、华为云obs 访问域名Endpoint ")
	protected String endpoint;

	@ApiModelProperty(value = "阿里云OSS、华为云obs 访问密钥Id AccessKeyId")
	protected String accessKeyId;

	@ApiModelProperty(value = "阿里云OSS、华为云obs 访问密钥Secret AccessKeySecret")
	protected String accessKeySecret;

	@ApiModelProperty(value = "状态：enable(生效)，disable（无效）")
	protected String status;

	@ApiModelProperty(value = "文件名是否加密（1：加密，0：不加密）")
	protected Integer encryptName;

	@ApiModelProperty(value = "存储配置描述")
	protected String desc;

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getStorageId() {
		return storageId;
	}

	public void setStorageId(String storageId) {
		this.storageId = storageId;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Double getAllowSize() {
		return allowSize;
	}

	public void setAllowSize(Double allowSize) {
		this.allowSize = allowSize;
	}

	public Integer getAllowDelete() {
		return allowDelete;
	}

	public void setAllowDelete(Integer allowDelete) {
		this.allowDelete = allowDelete;
	}

	public Integer getIsZone() {
		return isZone;
	}

	public void setIsZone(Integer isZone) {
		this.isZone = isZone;
	}

	public Integer getAllowMultiple() {
		return allowMultiple;
	}

	public void setAllowMultiple(Integer allowMultiple) {
		this.allowMultiple = allowMultiple;
	}

	public String getFileKinds() {
		return fileKinds;
	}

	public void setFileKinds(String fileKinds) {
		this.fileKinds = fileKinds;
	}

	public String getMemo() {
		return memo;
	}

	public void setMemo(String memo) {
		this.memo = memo;
	}

	public String getStorageName() {
		return storageName;
	}

	public void setStorageName(String storageName) {
		this.storageName = storageName;
	}

	public String getStorageCode() {
		return storageCode;
	}

	public void setStorageCode(String storageCode) {
		this.storageCode = storageCode;
	}

	public String getUploadType() {
		return uploadType;
	}

	public void setUploadType(String uploadType) {
		this.uploadType = uploadType;
	}

	public String getLocation() {
		return location;
	}

	public void setLocation(String location) {
		this.location = location;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public Integer getPort() {
		return port;
	}

	public void setPort(Integer port) {
		this.port = port;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getEndpoint() {
		return endpoint;
	}

	public void setEndpoint(String endpoint) {
		this.endpoint = endpoint;
	}

	public String getAccessKeyId() {
		return accessKeyId;
	}

	public void setAccessKeyId(String accessKeyId) {
		this.accessKeyId = accessKeyId;
	}

	public String getAccessKeySecret() {
		return accessKeySecret;
	}

	public void setAccessKeySecret(String accessKeySecret) {
		this.accessKeySecret = accessKeySecret;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public Integer getEncryptName() {
		return encryptName;
	}

	public void setEncryptName(Integer encryptName) {
		this.encryptName = encryptName;
	}

	public String getDesc() {
		return desc;
	}

	public void setDesc(String desc) {
		this.desc = desc;
	}
}
