package com.artfess.mdm.uc.manager.impl;

import com.artfess.mdm.uc.model.MdmOrgDemension;
import com.artfess.mdm.uc.dao.MdmOrgDemensionDao;
import com.artfess.mdm.uc.manager.MdmOrgDemensionManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.baomidou.dynamic.datasource.annotation.DS;
import org.jodconverter.office.utils.Lo;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

/**
 * 组织维度管理 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2025-01-16
 */
@Service
@DS("mdm")
@Transactional(rollbackFor = Exception.class)
public class MdmOrgDemensionManagerImpl extends BaseManagerImpl<MdmOrgDemensionDao, MdmOrgDemension> implements MdmOrgDemensionManager {

    @Override
    public boolean insertObj(MdmOrgDemension t) {
        t.setLastOperateTime(LocalDateTime.now());
        t.setLastTimeSeq(new Date().getTime());
        t.setIsDele("0");
        return this.save(t);
    }

    @Override
    public boolean updateObj(MdmOrgDemension t) {
        t.setLastOperateTime(LocalDateTime.now());
        t.setLastTimeSeq(new Date().getTime());
        return this.updateById(t);
    }

    @Override
    public boolean remove(String id) {
        MdmOrgDemension  orgDemension = this.getById(id);
        if(orgDemension == null){
            throw new RuntimeException("删除失败，根据输入的Id【" + id + "】错误！");
        }
        orgDemension.setLastOperateTime(LocalDateTime.now());
        orgDemension.setLastTimeSeq(new Date().getTime());
        this.updateById(orgDemension);
        return  this.removeById(id);
    }

    @Override
    public boolean removeBatchById(List<String> ids) {
        if(!CollectionUtils.isEmpty(ids)){
            for(String id : ids){
                remove(id);
            }
            return true;
        }
        return false;
    }

    @Override
    public MdmOrgDemension getObjById(String id) {
        Assert.hasText(id, "ID不能为空");
        return this.getById(id);
    }

}
