package com.artfess.mdm.uc.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.mdm.uc.model.MdmOrgBasic;

import java.util.List;

/**
 * 组织机构表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2025-02-08
 */
public interface MdmOrgBasicManager extends BaseManager<MdmOrgBasic> {
    /**
     * 添加实体
     * @param t
     * @return
     */
    boolean insertObj(MdmOrgBasic t);
    /**
     * 修改实体
     * @param t
     * @return
     */
    boolean updateObj(MdmOrgBasic t);

    /**
     * 根据ID删除
     * @param id 主键ID
     * @return
     */
    boolean remove(String  id);

    /**
     * 根据ID批量删除
     * @param ids
     * @return
     */
    boolean removeBatchById(List<String> ids);

    /**
     * 根据ID查询
     * @param id 主键ID
     * @return
     */
    MdmOrgBasic getObjById(String  id);

    /**
    * 根据版本获取组织机构信息
    * @param orgVersion  组织机构版本号
    * @Return: java.util.List<com.artfess.mdm.uc.model.MdmOrgBasic>
    * @Author: chens
    * @Date: 2025/2/8 16:50:56
    */
    List<MdmOrgBasic> getAllByVersion(Integer orgVersion);
}
