/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.util;

import com.artfess.base.util.StringUtil;
import com.artfess.dataShare.dataResource.app.model.BizAppCatalogsTableField;
import com.artfess.dataShare.dataResource.dw.model.BizDwdCatalogsTableField;
import com.artfess.dataShare.dataResource.ods.model.BizOdsField;
import com.artfess.dataShare.util.FieldUtil;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;

public class DorisUtils {
    public static String getOdsTableSql(String tableName, String tableDesc, List<BizOdsField> fields) {
        StringBuffer createSql = new StringBuffer();
        createSql.append("CREATE TABLE IF NOT EXISTS ").append(tableName);
        createSql.append("(\n");
        createSql.append(" `id_` VARCHAR(64) NOT NULL COMMENT \"\u4e3b\u952eid\",\n");
        String uniqueKey = "id_";
        for (int i = 0; i < fields.size(); ++i) {
            BizOdsField field = fields.get(i);
            if ("ID_".equalsIgnoreCase(field.getFieldName())) continue;
            Integer attrLength = field.getAttrLength() == null ? 0 : field.getAttrLength();
            Integer decimalLen = field.getDecimalLen() == null ? 4 : field.getDecimalLen();
            String fieldSql = "`" + field.getFieldName() + "` " + FieldUtil.getColumnType(field.getDataType(), attrLength, attrLength, decimalLen) + " NULL COMMENT \"" + field.getDesc() + "\"";
            if (i == fields.size() - 1) {
                createSql.append(" ").append(fieldSql);
            } else {
                createSql.append(" ").append(fieldSql).append(",\n");
            }
            if (!"1".equalsIgnoreCase(field.getIsPartition())) continue;
            uniqueKey = uniqueKey + "," + field.getFieldName();
        }
        createSql.append(")\n");
        createSql.append(" ENGINE=OLAP\n");
        createSql.append(" UNIQUE KEY(" + uniqueKey + ") \n");
        if (StringUtil.isNotEmpty((String)tableDesc)) {
            createSql.append(" COMMENT  '" + tableDesc + "' \n");
        }
        createSql.append(" DISTRIBUTED BY HASH(`id_`) BUCKETS 16");
        createSql.append(" PROPERTIES\n");
        createSql.append("(\n");
        createSql.append("\"replication_num\" = \"3\"\n");
        createSql.append(")");
        return createSql.toString();
    }

    public static String createTable(JdbcTemplate template, String tableName, String tableDesc, List<BizOdsField> fields) {
        String createSql = DorisUtils.getOdsTableSql(tableName, tableDesc, fields);
        System.out.println(createSql);
        template.execute(createSql);
        return createSql;
    }

    public static String getDWDWLTableSql(String tableName, String tableDesc, List<BizDwdCatalogsTableField> fields) {
        StringBuffer createSql = new StringBuffer();
        createSql.append("CREATE TABLE IF NOT EXISTS ").append(tableName);
        createSql.append("(\n");
        createSql.append(" `id_` VARCHAR(64) NOT NULL COMMENT \"\u4e3b\u952eid\",\n");
        for (int i = 0; i < fields.size(); ++i) {
            BizDwdCatalogsTableField field = fields.get(i);
            if ("ID_".equalsIgnoreCase(field.getFieldCode())) continue;
            Integer attrLength = field.getAttrLength() == null ? 0 : field.getAttrLength();
            Integer decimalLen = field.getDecimalLen() == null ? 4 : field.getDecimalLen();
            String fieldSql = "`" + field.getFieldCode() + "` " + FieldUtil.getColumnType(field.getDataType(), attrLength, attrLength, decimalLen) + " NULL COMMENT \"" + field.getDesc() + "\"";
            if (i == fields.size() - 1) {
                createSql.append(" ").append(fieldSql);
                continue;
            }
            createSql.append(" ").append(fieldSql).append(",\n");
        }
        createSql.append(")\n");
        createSql.append(" ENGINE=OLAP\n");
        if (StringUtil.isNotEmpty((String)tableDesc)) {
            createSql.append(" COMMENT  '" + tableDesc + "' \n");
        }
        createSql.append(" DISTRIBUTED BY HASH(`id_`) BUCKETS 16");
        createSql.append(" PROPERTIES\n");
        createSql.append("(\n");
        createSql.append("\"replication_num\" = \"3\"\n");
        createSql.append(")");
        return createSql.toString();
    }

    public static String createDwTable(JdbcTemplate template, String tableName, String tableDesc, List<BizDwdCatalogsTableField> fields) {
        String createSql = DorisUtils.getDWDWLTableSql(tableName, tableDesc, fields);
        System.out.println(createSql);
        template.execute(createSql);
        return createSql;
    }

    public static String getAPPTableSql(String tableName, String tableDesc, List<BizAppCatalogsTableField> fields) {
        StringBuffer createSql = new StringBuffer();
        createSql.append("CREATE TABLE IF NOT EXISTS ").append(tableName);
        createSql.append("(\n");
        createSql.append(" `id_` VARCHAR(64) NOT NULL COMMENT \"\u4e3b\u952eid\",\n");
        for (int i = 0; i < fields.size(); ++i) {
            BizAppCatalogsTableField field = fields.get(i);
            if ("ID_".equalsIgnoreCase(field.getFieldCode())) continue;
            Integer attrLength = field.getAttrLength() == null ? 0 : field.getAttrLength();
            Integer decimalLen = field.getDecimalLen() == null ? 4 : field.getDecimalLen();
            String fieldSql = "`" + field.getFieldCode() + "` " + FieldUtil.getColumnType(field.getDataType(), attrLength, attrLength, decimalLen) + " NULL COMMENT \"" + field.getDesc() + "\"";
            if (i == fields.size() - 1) {
                createSql.append(" ").append(fieldSql);
                continue;
            }
            createSql.append(" ").append(fieldSql).append(",\n");
        }
        createSql.append(")\n");
        createSql.append(" ENGINE=OLAP\n");
        if (StringUtil.isNotEmpty((String)tableDesc)) {
            createSql.append(" COMMENT  '" + tableDesc + "' \n");
        }
        createSql.append(" DISTRIBUTED BY HASH(`id_`) BUCKETS 16");
        createSql.append(" PROPERTIES\n");
        createSql.append("(\n");
        createSql.append("\"replication_num\" = \"3\"\n");
        createSql.append(")");
        return createSql.toString();
    }

    public static String createAppTable(JdbcTemplate template, String tableName, String tableDesc, List<BizAppCatalogsTableField> fields) {
        String createSql = DorisUtils.getAPPTableSql(tableName, tableDesc, fields);
        template.execute(createSql);
        return createSql;
    }

    public static void createDwTable(JdbcTemplate template, String tableName, String tableDesc) {
        String createDwdMainSql = DorisUtils.queryDwdMainSql(tableName, tableDesc);
        template.execute(createDwdMainSql);
        String createDwdDetailSql = DorisUtils.queryDwdDetailSql(tableName, tableDesc);
        template.execute(createDwdDetailSql);
    }

    public static String queryDwdMainSql(String tableName, String tableDesc) {
        if (StringUtil.isEmpty((String)tableName)) {
            return "";
        }
        StringBuffer createDwdMainSql = new StringBuffer("create table DWD_BIZ_" + tableName + "_DATA\n" + "(\n" + "   ID_                  VARCHAR(64) not null comment '\u4e3b\u952eID',\n" + "   USER_ID_             VARCHAR(64) comment '\u4e2a\u4ebaID',\n" + "   USER_NAME_           varchar(64) default NULL comment '\u4e2a\u4eba\u59d3\u540d',\n" + "   USER_SEX_            varchar(6) default NULL comment '\u4e2a\u4eba\u6027\u522b',\n" + "   USER_IDENTITY_CARD_  varchar(18) default NULL comment '\u8eab\u4efd\u8bc1\u53f7',\n" + "   USER_PHONE_          varchar(18) default NULL comment '\u79fb\u52a8\u624b\u673a\u53f7',\n" + "   DATA_ID_             VARCHAR(32) comment '\u6570\u636e\u6279\u6b21ID\uff08\u540c\u4e00\u6761\u8bb0\u5f55\u6570\u636e\u6279\u6b21ID\u76f8\u540c\uff09',\n" + "   TABLE_CODE_          VARCHAR(32) comment '\u6570\u636e\u8d44\u6e90\u660e\u7ec6\u9879\u7f16\u7801',\n" + "   DATA_JSON_           VARCHAR(4000) comment '\u5b57\u6bb5\u6570\u636eJSON\u7ec4\u5408\u4e32',\n" + "   FIELD_VALUE_TIME_    datetime comment '\u5b57\u6bb5\u6570\u636e\u6240\u5c5e\u65f6\u95f4',\n" + "   VERSION              VARCHAR(16) comment '\u6570\u636e\u7248\u672c\u53f7\uff08\u540c\u4e00\u6279\u6570\u636e\u7248\u672c\u53f7\u76f8\u540c\uff09',\n" + "   CREATE_BY_           VARCHAR(64) default NULL comment '\u521b\u5efa\u4eba',\n" + "   CREATE_ORG_ID_       VARCHAR(64) default NULL comment '\u521b\u5efa\u5355\u4f4d',\n" + "   CREATE_TIME_         datetime comment '\u521b\u5efa\u65f6\u95f4',\n" + "   UPDATE_BY_           VARCHAR(64) default NULL comment '\u4fee\u6539\u4eba\u5458',\n" + "   UPDATE_ORG_ID_       VARCHAR(64) default NULL comment '\u4fee\u6539\u5355\u4f4d',\n" + "   UPDATE_TIME_         datetime comment '\u4fee\u6539\u65f6\u95f4',\n" + "   TENANT_ID_           VARCHAR(64) default NULL comment '\u79df\u6237ID'\n");
        createDwdMainSql.append(")\n");
        createDwdMainSql.append(" ENGINE=OLAP\n");
        createDwdMainSql.append(" UNIQUE KEY(`id_`)\n");
        if (StringUtil.isNotEmpty((String)tableDesc)) {
            createDwdMainSql.append(" COMMENT  '" + tableDesc + "' \n");
        }
        createDwdMainSql.append(" DISTRIBUTED BY HASH(`id_`) BUCKETS 16");
        createDwdMainSql.append(" PROPERTIES\n");
        createDwdMainSql.append("(\n");
        createDwdMainSql.append("\"replication_num\" = \"1\"\n");
        createDwdMainSql.append(")");
        return createDwdMainSql.toString();
    }

    public static String queryDwdDetailSql(String tableName, String tableDesc) {
        if (StringUtil.isEmpty((String)tableName)) {
            return "";
        }
        StringBuffer createDwdDetailSql = new StringBuffer("create table DWD_" + tableName + "_TABLE_RECORD\n" + "(\n" + "   ID_                  VARCHAR(64) not null comment '\u4e3b\u952eID\uff08\u91c7\u7528\u9012\u589e\u5373\u53ef\uff09',\n" + "   USER_ID_             VARCHAR(64) comment '\u4e2a\u4ebaID',\n" + "   USER_NAME_           varchar(64) default NULL comment '\u4e2a\u4eba\u59d3\u540d',\n" + "   USER_SEX_            varchar(6) default NULL comment '\u4e2a\u4eba\u6027\u522b',\n" + "   USER_IDENTITY_CARD_  varchar(18) default NULL comment '\u8eab\u4efd\u8bc1\u53f7',\n" + "   USER_PHONE_          varchar(18) default NULL comment '\u79fb\u52a8\u624b\u673a\u53f7',\n" + "   DATA_ID_             VARCHAR(32) comment '\u6570\u636e\u6279\u6b21ID\uff08\u540c\u4e00\u6761\u8bb0\u5f55\u6570\u636e\u6279\u6b21ID\u76f8\u540c\uff09',\n" + "   TABLE_CODE_          VARCHAR(32) comment '\u6570\u636e\u8d44\u6e90\u660e\u7ec6\u9879\u7f16\u7801',\n" + "   FIELD_ID_            VARCHAR(32) default NULL comment '\u5b57\u6bb5ID(\u6240\u5c5e\u5b57\u6bb5\u5b9a\u4e49\u8868ID)',\n" + "   FIELD_CODE_          VARCHAR(32) comment '\u5b57\u6bb5\u5217\u540d(\u6240\u5c5e\u5b57\u6bb5\u5b9a\u4e49\u8868\u5b57\u6bb5\u540d)',\n" + "   FIELD_VALUE_         varchar(2000) default NULL comment '\u5b57\u6bb5\u503cValue',\n" + "   FIELD_UI_MODULE_     varchar(2) default NULL comment '\u5b57\u6bb5\u63a7\u4ef6\uff081\u624b\u52a8\u8f93\u51652\u4e0b\u62c9\u7ec4\u4ef63\u590d\u9009\u7ec4\u4ef64\u5355\u9009\u7ec4\u4ef65\u65e5\u671f\u7ec4\u4ef66\u6570\u5b57\u7ec4\u4ef6\uff09',\n" + "   FIELD_VALUE_TIME_    datetime comment '\u5b57\u6bb5\u6570\u636e\u6240\u5c5e\u65f6\u95f4',\n" + "   VERSION              VARCHAR(16) comment '\u6570\u636e\u7248\u672c\u53f7\uff08\u540c\u4e00\u6279\u6570\u636e\u7248\u672c\u53f7\u76f8\u540c\uff09',\n" + "   CREATE_BY_           VARCHAR(64) default NULL comment '\u521b\u5efa\u4eba',\n" + "   CREATE_ORG_ID_       VARCHAR(64) default NULL comment '\u521b\u5efa\u5355\u4f4d',\n" + "   CREATE_TIME_         datetime comment '\u521b\u5efa\u65f6\u95f4',\n" + "   UPDATE_BY_           VARCHAR(64) default NULL comment '\u4fee\u6539\u4eba\u5458',\n" + "   UPDATE_ORG_ID_       VARCHAR(64) default NULL comment '\u4fee\u6539\u5355\u4f4d',\n" + "   UPDATE_TIME_         datetime comment '\u4fee\u6539\u65f6\u95f4',\n" + "   TENANT_ID_           VARCHAR(64) default NULL comment '\u79df\u6237ID'\n");
        createDwdDetailSql.append(")\n");
        createDwdDetailSql.append(" ENGINE=OLAP\n");
        createDwdDetailSql.append(" UNIQUE KEY(`id_`)\n");
        if (StringUtil.isNotEmpty((String)tableDesc)) {
            createDwdDetailSql.append(" COMMENT  '" + tableDesc + "' \n");
        }
        createDwdDetailSql.append(" DISTRIBUTED BY HASH(`id_`) BUCKETS 16");
        createDwdDetailSql.append(" PROPERTIES\n");
        createDwdDetailSql.append("(\n");
        createDwdDetailSql.append("\"replication_num\" = \"1\"\n");
        createDwdDetailSql.append(")");
        return createDwdDetailSql.toString();
    }

    public static String queryAppMainSql(String tableName, String tableDesc) {
        if (StringUtil.isEmpty((String)tableName)) {
            return "";
        }
        StringBuffer createDwdMainSql = new StringBuffer("create table APP_D_" + tableName + "\n" + "(\n" + "   ID_                  VARCHAR(64) not null comment '\u4e3b\u952eID',\n" + "   USER_ID_             VARCHAR(64) comment '\u4e2a\u4ebaID',\n" + "   USER_NAME_           varchar(64) default NULL comment '\u4e2a\u4eba\u59d3\u540d',\n" + "   USER_SEX_            varchar(6) default NULL comment '\u4e2a\u4eba\u6027\u522b',\n" + "   USER_IDENTITY_CARD_  varchar(18) default NULL comment '\u8eab\u4efd\u8bc1\u53f7',\n" + "   USER_PHONE_          varchar(18) default NULL comment '\u79fb\u52a8\u624b\u673a\u53f7',\n" + "   DATA_ID_             VARCHAR(32) comment '\u6570\u636e\u6279\u6b21ID\uff08\u540c\u4e00\u6761\u8bb0\u5f55\u6570\u636e\u6279\u6b21ID\u76f8\u540c\uff09',\n" + "   TABLE_CODE_          VARCHAR(32) comment '\u6570\u636e\u8d44\u6e90\u660e\u7ec6\u9879\u7f16\u7801',\n" + "   DATA_JSON_           VARCHAR(4000) comment '\u5b57\u6bb5\u6570\u636eJSON\u7ec4\u5408\u4e32',\n" + "   FIELD_VALUE_TIME_    datetime comment '\u5b57\u6bb5\u6570\u636e\u6240\u5c5e\u65f6\u95f4',\n" + "   VERSION              VARCHAR(16) comment '\u6570\u636e\u7248\u672c\u53f7\uff08\u540c\u4e00\u6279\u6570\u636e\u7248\u672c\u53f7\u76f8\u540c\uff09',\n" + "   CREATE_BY_           VARCHAR(64) default NULL comment '\u521b\u5efa\u4eba',\n" + "   CREATE_ORG_ID_       VARCHAR(64) default NULL comment '\u521b\u5efa\u5355\u4f4d',\n" + "   CREATE_TIME_         datetime comment '\u521b\u5efa\u65f6\u95f4',\n" + "   UPDATE_BY_           VARCHAR(64) default NULL comment '\u4fee\u6539\u4eba\u5458',\n" + "   UPDATE_ORG_ID_       VARCHAR(64) default NULL comment '\u4fee\u6539\u5355\u4f4d',\n" + "   UPDATE_TIME_         datetime comment '\u4fee\u6539\u65f6\u95f4',\n" + "   TENANT_ID_           VARCHAR(64) default NULL comment '\u79df\u6237ID'\n");
        createDwdMainSql.append(")\n");
        createDwdMainSql.append(" ENGINE=OLAP\n");
        createDwdMainSql.append(" UNIQUE KEY(`id_`)\n");
        if (StringUtil.isNotEmpty((String)tableDesc)) {
            createDwdMainSql.append(" COMMENT '" + tableDesc + "' \n");
        }
        createDwdMainSql.append(" DISTRIBUTED BY HASH(`id_`) BUCKETS 16");
        createDwdMainSql.append(" PROPERTIES\n");
        createDwdMainSql.append("(\n");
        createDwdMainSql.append("\"replication_num\" = \"1\"\n");
        createDwdMainSql.append(")");
        return createDwdMainSql.toString();
    }

    public static String queryAppDetailSql(String tableName, String tableDesc) {
        if (StringUtil.isEmpty((String)tableName)) {
            return "";
        }
        StringBuffer createDwdDetailSql = new StringBuffer("create table APP_D_" + tableName + "_COLUMN\n" + "(\n" + "   ID_                  VARCHAR(64) not null comment '\u4e3b\u952eID\uff08\u91c7\u7528\u9012\u589e\u5373\u53ef\uff09',\n" + "   USER_ID_             VARCHAR(64) comment '\u4e2a\u4ebaID',\n" + "   USER_NAME_           varchar(64) default NULL comment '\u4e2a\u4eba\u59d3\u540d',\n" + "   USER_SEX_            varchar(6) default NULL comment '\u4e2a\u4eba\u6027\u522b',\n" + "   USER_IDENTITY_CARD_  varchar(18) default NULL comment '\u8eab\u4efd\u8bc1\u53f7',\n" + "   USER_PHONE_          varchar(18) default NULL comment '\u79fb\u52a8\u624b\u673a\u53f7',\n" + "   DATA_ID_             VARCHAR(32) comment '\u6570\u636e\u6279\u6b21ID\uff08\u540c\u4e00\u6761\u8bb0\u5f55\u6570\u636e\u6279\u6b21ID\u76f8\u540c\uff09',\n" + "   TABLE_CODE_          VARCHAR(32) comment '\u6570\u636e\u8d44\u6e90\u660e\u7ec6\u9879\u7f16\u7801',\n" + "   FIELD_ID_            VARCHAR(32) default NULL comment '\u5b57\u6bb5ID(\u6240\u5c5e\u5b57\u6bb5\u5b9a\u4e49\u8868ID)',\n" + "   FIELD_CODE_          VARCHAR(32) comment '\u5b57\u6bb5\u5217\u540d(\u6240\u5c5e\u5b57\u6bb5\u5b9a\u4e49\u8868\u5b57\u6bb5\u540d)',\n" + "   FIELD_VALUE_         varchar(2000) default NULL comment '\u5b57\u6bb5\u503cValue',\n" + "   FIELD_UI_MODULE_     varchar(2) default NULL comment '\u5b57\u6bb5\u63a7\u4ef6\uff081\u624b\u52a8\u8f93\u51652\u4e0b\u62c9\u7ec4\u4ef63\u590d\u9009\u7ec4\u4ef64\u5355\u9009\u7ec4\u4ef65\u65e5\u671f\u7ec4\u4ef66\u6570\u5b57\u7ec4\u4ef6\uff09',\n" + "   FIELD_VALUE_TIME_    datetime comment '\u5b57\u6bb5\u6570\u636e\u6240\u5c5e\u65f6\u95f4',\n" + "   VERSION              VARCHAR(16) comment '\u6570\u636e\u7248\u672c\u53f7\uff08\u540c\u4e00\u6279\u6570\u636e\u7248\u672c\u53f7\u76f8\u540c\uff09',\n" + "   CREATE_BY_           VARCHAR(64) default NULL comment '\u521b\u5efa\u4eba',\n" + "   CREATE_ORG_ID_       VARCHAR(64) default NULL comment '\u521b\u5efa\u5355\u4f4d',\n" + "   CREATE_TIME_         datetime comment '\u521b\u5efa\u65f6\u95f4',\n" + "   UPDATE_BY_           VARCHAR(64) default NULL comment '\u4fee\u6539\u4eba\u5458',\n" + "   UPDATE_ORG_ID_       VARCHAR(64) default NULL comment '\u4fee\u6539\u5355\u4f4d',\n" + "   UPDATE_TIME_         datetime comment '\u4fee\u6539\u65f6\u95f4',\n" + "   TENANT_ID_           VARCHAR(64) default NULL comment '\u79df\u6237ID'\n");
        createDwdDetailSql.append(")\n");
        createDwdDetailSql.append(" ENGINE=OLAP\n");
        createDwdDetailSql.append(" UNIQUE KEY(`id_`)\n");
        if (StringUtil.isNotEmpty((String)tableDesc)) {
            createDwdDetailSql.append(" COMMENT  '" + tableDesc + "' \n");
        }
        createDwdDetailSql.append(" DISTRIBUTED BY HASH(`id_`) BUCKETS 16");
        createDwdDetailSql.append(" PROPERTIES\n");
        createDwdDetailSql.append("(\n");
        createDwdDetailSql.append("\"replication_num\" = \"1\"\n");
        createDwdDetailSql.append(")");
        return createDwdDetailSql.toString();
    }
}

