/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.table.operator.impl;

import com.artfess.base.manager.CommonManager;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.util.AppUtil;
import com.artfess.table.meta.impl.BaseDbType;
import com.artfess.table.model.Table;
import com.artfess.table.model.impl.DefaultColumn;
import com.artfess.table.model.impl.DefaultTable;
import com.artfess.table.operator.IViewOperator;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.springframework.jdbc.core.RowMapper;

public abstract class BaseViewOperator
extends BaseDbType
implements IViewOperator {
    public abstract String getType(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Table getModelByViewName(String viewName) throws SQLException {
        ResultSet rs = null;
        DefaultTable table = new DefaultTable();
        table.setTableName(viewName);
        table.setComment(viewName);
        try (Connection conn = this.jdbcTemplate.getDataSource().getConnection();
             Statement stmt = conn.createStatement();){
            stmt.setMaxRows(1);
            rs = stmt.executeQuery("select * from " + viewName);
            ResultSetMetaData metadata = rs.getMetaData();
            int count = metadata.getColumnCount();
            for (int i = 1; i <= count; ++i) {
                DefaultColumn column = new DefaultColumn();
                String columnName = metadata.getColumnName(i);
                String typeName = metadata.getColumnTypeName(i);
                String dataType = this.getType(typeName);
                column.setFieldName(columnName);
                column.setColumnType(dataType);
                column.setComment(columnName);
                table.addColumn(column);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return table;
    }

    protected <T> PageList<T> getForList(String sql, PageBean pageBean, Class<T> elementType) throws Exception {
        if (pageBean != null) {
            CommonManager commonManager = (CommonManager)AppUtil.getBean(CommonManager.class);
            PageList result = commonManager.query(sql, pageBean);
            return result;
        }
        List queryForList = this.jdbcTemplate.queryForList(sql, elementType);
        return new PageList(queryForList);
    }

    protected <T> PageList<T> getForList(String sql, PageBean pageBean, RowMapper<T> rowMapper) throws Exception {
        if (pageBean != null) {
            CommonManager commonManager = (CommonManager)AppUtil.getBean(CommonManager.class);
            PageList result = commonManager.query(sql, pageBean);
            return result;
        }
        List queryForList = this.jdbcTemplate.query(sql, rowMapper);
        return new PageList(queryForList);
    }
}

