/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.table.operator.impl.postgresql;

import com.artfess.table.model.Column;
import com.artfess.table.model.Table;
import com.artfess.table.operator.impl.BaseTableOperator;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowMapper;

public class PostgreSQLTableOperator
extends BaseTableOperator {
    @Override
    public void createTable(Table table) throws SQLException {
        List<Column> columnList = table.getColumnList();
        ArrayList<String> sqlList = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        String pkColumn = null;
        sb.append("CREATE TABLE " + table.getTableName() + " (\n");
        for (int i = 0; i < columnList.size(); ++i) {
            Column cm = columnList.get(i);
            sb.append(cm.getFieldName()).append(" ");
            sb.append(this.getColumnType(cm.getColumnType(), cm.getCharLen(), cm.getIntLen(), cm.getDecimalLen()));
            sb.append(cm.getIsRequired() == 1 ? " NOT NULL " : " ");
            sb.append(" ");
            String defaultValue = cm.getDefaultValue();
            if (StringUtils.isNotEmpty((String)defaultValue)) {
                if ("date".equals(cm.getColumnType())) {
                    defaultValue = this.formatTimeDefaultValue(cm, defaultValue);
                }
                if ("number".equals(cm.getColumnType()) || "int".equals(cm.getColumnType())) {
                    sb.append(" default " + defaultValue);
                } else {
                    sb.append(" default '" + defaultValue + "' ");
                }
            }
            if (cm.getIsPk()) {
                pkColumn = pkColumn == null ? cm.getFieldName() : pkColumn + "," + cm.getFieldName();
            }
            sb.append(",\n");
            if (cm.getComment() == null || cm.getComment().length() <= 0) continue;
            sqlList.add(" COMMENT ON column " + table.getTableName() + "." + cm.getFieldName() + " is '" + cm.getComment() + "';");
        }
        if (pkColumn != null) {
            sb.append(" PRIMARY KEY (" + pkColumn + ")");
        }
        sb.append("\n)");
        sb.append(";");
        sqlList.add(0, sb.toString());
        if (table.getComment() != null && table.getComment().length() > 0) {
            sqlList.add(1, " COMMENT ON TABLE " + table.getTableName() + " is '" + table.getComment() + "';");
        }
        String[] sql = new String[sqlList.size()];
        sqlList.toArray(sql);
        this.jdbcTemplate.batchUpdate(sql);
    }

    @Override
    public String createTableSql(Table table) throws SQLException {
        List<Column> columnList = table.getColumnList();
        ArrayList<String> sqlList = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        String pkColumn = null;
        sb.append("CREATE TABLE " + table.getTableName() + " (\n");
        for (int i = 0; i < columnList.size(); ++i) {
            Column cm = columnList.get(i);
            sb.append(cm.getFieldName()).append(" ");
            sb.append(this.getColumnType(cm.getColumnType(), cm.getCharLen(), cm.getIntLen(), cm.getDecimalLen()));
            sb.append(cm.getIsRequired() == 1 ? " NOT NULL " : " ");
            sb.append(" ");
            String defaultValue = cm.getDefaultValue();
            if (StringUtils.isNotEmpty((String)defaultValue)) {
                if ("date".equals(cm.getColumnType())) {
                    defaultValue = this.formatTimeDefaultValue(cm, defaultValue);
                }
                if ("number".equals(cm.getColumnType()) || "int".equals(cm.getColumnType())) {
                    sb.append(" default " + defaultValue);
                } else {
                    sb.append(" default '" + defaultValue + "' ");
                }
            }
            if (cm.getIsPk()) {
                pkColumn = pkColumn == null ? cm.getFieldName() : pkColumn + "," + cm.getFieldName();
            }
            sb.append(",\n");
            if (cm.getComment() == null || cm.getComment().length() <= 0) continue;
            sqlList.add(" COMMENT ON column " + table.getTableName() + "." + cm.getFieldName() + " is '" + cm.getComment() + "';");
        }
        if (pkColumn != null) {
            sb.append(" PRIMARY KEY (" + pkColumn + ")");
        }
        sb.append("\n)");
        sb.append(";");
        sqlList.add(0, sb.toString());
        if (table.getComment() != null && table.getComment().length() > 0) {
            sqlList.add(1, " COMMENT ON TABLE " + table.getTableName() + " is '" + table.getComment() + "';");
        }
        String[] sql = new String[sqlList.size()];
        sqlList.toArray(sql);
        return sb.toString();
    }

    @Override
    public String getColumnType(Column column) {
        return this.getColumnType(column.getColumnType(), column.getCharLen(), column.getIntLen(), column.getDecimalLen());
    }

    @Override
    public String getColumnType(String columnType, int charLen, int intLen, int decimalLen) {
        if ("varchar".equals(columnType)) {
            return "VARCHAR(" + charLen + ')';
        }
        if ("number".equals(columnType)) {
            return "DECIMAL(" + (intLen + decimalLen) + "," + decimalLen + ")";
        }
        if ("date".equals(columnType)) {
            return "TIMESTAMP NULL";
        }
        if ("int".equals(columnType)) {
            return "BIGINT";
        }
        if ("clob".equals(columnType)) {
            return "TEXT";
        }
        return "";
    }

    @Override
    public void dropTable(String tableName) throws SQLException {
        if (!this.isTableExist(tableName)) {
            return;
        }
        String sql = "drop table " + tableName;
        this.jdbcTemplate.execute(sql);
    }

    @Override
    public void updateTableComment(String tableName, String comment) throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ").append(tableName).append(" COMMENT '").append(comment).append("';\n");
        this.jdbcTemplate.execute(sb.toString());
    }

    @Override
    public void addColumn(String tableName, Column model) throws SQLException {
        String[] sql = new String[2];
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ").append(tableName);
        sb.append(" ADD ");
        sb.append(model.getFieldName()).append(" ");
        sb.append(this.getColumnType(model.getColumnType(), model.getCharLen(), model.getIntLen(), model.getDecimalLen()));
        if (model.getIsRequired() == 1 && !"date".equals(model.getColumnType())) {
            sb.append(" NOT NULL ");
        }
        sb.append(";");
        sql[0] = sb.toString();
        if (model.getComment() != null && model.getComment().length() > 0) {
            sql[1] = " COMMENT ON column " + tableName + "." + model.getFieldName() + " is '" + model.getComment() + "';";
        }
        this.jdbcTemplate.batchUpdate(sql);
    }

    @Override
    public void dropColumn(String tableName, String columnName) throws SQLException {
        String sql = "ALTER TABLE " + tableName + " DROP COLUMN  " + columnName;
        this.jdbcTemplate.execute(sql);
    }

    @Override
    public void updateColumn(String tableName, String columnName, Column column) throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ").append(tableName).append(" CHANGE " + columnName + " " + column.getFieldName()).append(" ").append(this.getColumnType(column.getColumnType(), column.getCharLen(), column.getIntLen(), column.getDecimalLen()));
        if (!column.getIsNull()) {
            sb.append(" NOT NULL ");
        }
        if (column.getComment() != null && column.getComment().length() > 0) {
            sb.append(" COMMENT '" + column.getComment() + "'");
        }
        sb.append(";");
        this.jdbcTemplate.execute(sb.toString());
    }

    @Override
    public void addForeignKey(String pkTableName, String fkTableName, String pkField, String fkField) {
        String shortTableName = fkTableName.replaceFirst("(?im)W_", "");
        String sql = "ALTER TABLE " + fkTableName + " ADD CONSTRAINT fk_" + shortTableName + " FOREIGN KEY (" + fkField + ") REFERENCES " + pkTableName + " (" + pkField + ") ON DELETE CASCADE";
        this.jdbcTemplate.execute(sql);
    }

    @Override
    public void dropForeignKey(String tableName, String keyName) {
        String sql = "ALTER TABLE " + tableName + " DROP FOREIGN KEY " + keyName;
        this.jdbcTemplate.execute(sql);
    }

    @Override
    public List<String> getPKColumns(String tableName) throws SQLException {
        String schema = this.getSchema();
        String sql = "SELECT k.column_name FROM information_schema.table_constraints t JOIN information_schema.key_column_usage k USING(constraint_name,table_schema,table_name) WHERE t.constraint_type='PRIMARY KEY' AND t.table_schema='" + schema + "' " + "AND t.table_name='" + tableName + "'";
        List columns = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                String column = rs.getString(1);
                return column;
            }
        });
        return columns;
    }

    @Override
    public Map<String, List<String>> getPKColumns(List<String> tableNames) throws SQLException {
        StringBuffer sb = new StringBuffer();
        for (String name : tableNames) {
            sb.append("'");
            sb.append(name);
            sb.append("',");
        }
        sb.deleteCharAt(sb.length() - 1);
        String schema = this.getSchema();
        String sql = "SELECT t.table_name,k.column_name FROM information_schema.table_constraints t JOIN information_schema.key_column_usage k USING(constraint_name,table_schema,table_name) WHERE t.constraint_type='PRIMARY KEY' AND t.table_schema='" + schema + "' " + "AND t.table_name in (" + sb.toString().toUpperCase() + ")";
        HashMap<String, List<String>> columnsMap = new HashMap<String, List<String>>();
        List maps = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<Map<String, String>>(){

            public Map<String, String> mapRow(ResultSet rs, int rowNum) throws SQLException {
                String table = rs.getString(1);
                String column = rs.getString(2);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", table);
                map.put("column", column);
                return map;
            }
        });
        for (Map map : maps) {
            if (columnsMap.containsKey(map.get("name"))) {
                ((List)columnsMap.get(map.get("name"))).add(map.get("column"));
                continue;
            }
            ArrayList cols = new ArrayList();
            cols.add(map.get("column"));
            columnsMap.put((String)map.get("name"), cols);
        }
        return columnsMap;
    }

    @Override
    public boolean isTableExist(String tableName) {
        String schema = this.getSchema();
        String sql = "select count(1) from information_schema.TABLES t where t.TABLE_CATALOG='" + schema + "' and table_name ='" + tableName.toLowerCase() + "'";
        return (Integer)this.jdbcTemplate.queryForObject(sql.toString(), Integer.class) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSchema() {
        String schema = null;
        Connection conn = null;
        try {
            conn = this.jdbcTemplate.getDataSource().getConnection();
            schema = conn.getCatalog();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return schema;
    }

    @Override
    public boolean isExsitPartition(String tableName, String partition) {
        partition = this.replaceLineThrough(partition);
        String sql = "select count(*) from information_schema.partitions  where table_schema = schema() and table_name=? and partition_name =?";
        Object[] args = new String[]{tableName, "P_" + partition};
        Integer rtn = (Integer)this.jdbcTemplate.queryForObject(sql, args, Integer.class);
        return rtn > 0;
    }

    @Override
    public void createPartition(String tableName, String partition) {
        partition = this.replaceLineThrough(partition);
        String sql = "alter table " + tableName + " add partition (partition P_" + partition + " values in ('" + partition + "')) ";
        this.jdbcTemplate.update(sql);
    }

    @Override
    public boolean supportPartition(String tableName) {
        String sql = "select count(*) from information_schema.partitions  where table_schema = schema() and table_name=? ";
        Integer rtn = (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class, new Object[]{tableName});
        return rtn > 0;
    }

    private String formatTimeDefaultValue(Column cm, String defaultValue) {
        return defaultValue;
    }
}

